/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.datamodel;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.ListElement;

public class ListManager {
    private int nextViewId_ = 0;
    private Vector itemsList_ = new Vector();
    private Hashtable itemsTable_ = new Hashtable();

    private final void updateManager(ListElement element) {
        this.itemsTable_.put(String.valueOf(this.nextViewId_), element);
        element.setViewId(this.nextViewId_);
        ++this.nextViewId_;
    }

    public final void add(ListElement element) {
        this.itemsList_.addElement(element);
        this.updateManager(element);
    }

    public final void addWithCurrentViewId(ListElement element) {
        this.itemsList_.addElement(element);
        this.itemsTable_.put(String.valueOf(element.getViewId()), element);
    }

    public final ListElement elementAt(int index) {
        return (ListElement)this.itemsList_.elementAt(index);
    }

    public final ListElement getElementWithViewId(int viewId) {
        return (ListElement)this.itemsTable_.get(String.valueOf(viewId));
    }

    public final void removeElementWithViewId(int viewId) {
        this.itemsTable_.remove(String.valueOf(viewId));
        int i = 0;
        while (i < this.itemsList_.size()) {
            ListElement listElement = this.elementAt(i);
            if (listElement.getViewId() == viewId) {
                this.itemsList_.removeElementAt(i);
                break;
            }
            ++i;
        }
    }

    public final void removeElementAt(int index) {
        ListElement listElement = this.elementAt(index);
        this.itemsList_.removeElementAt(index);
        this.itemsTable_.remove(String.valueOf(listElement.getViewId()));
    }

    public final void insertElementAt(ListElement element, int index) {
        this.itemsList_.insertElementAt(element, index);
        this.updateManager(element);
    }

    public final Enumeration getListElements() {
        return this.itemsList_.elements();
    }

    public final void clear() {
        this.itemsList_.removeAllElements();
        this.itemsTable_.clear();
    }

    public final ListManager copy(ListManager newListManager) {
        newListManager.clear();
        int i = 0;
        while (i < this.itemsList_.size()) {
            ListElement listElement = this.elementAt(i);
            ListElement newListElement = new ListElement(listElement.getObject());
            newListElement.setViewId(listElement.getViewId());
            newListElement.setTargetViewToolInfo(listElement.getTargetNodeId(), listElement.getTargetToolId(), listElement.getTargetViewId());
            newListManager.addWithCurrentViewId(newListElement);
            ++i;
        }
        newListManager.setNextViewId(this.nextViewId_);
        return newListManager;
    }

    public final void setNextViewId(int nextViewId) {
        this.nextViewId_ = nextViewId;
    }

    public final int getNextViewId() {
        return this.nextViewId_;
    }
}

