/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.docker.core;

import com.spotify.docker.client.messages.ContainerInfo;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.eclipse.linuxtools.docker.core.IDockerContainerConfig;
import org.eclipse.linuxtools.docker.core.IDockerContainerInfo;
import org.eclipse.linuxtools.docker.core.IDockerContainerState;
import org.eclipse.linuxtools.docker.core.IDockerHostConfig;
import org.eclipse.linuxtools.docker.core.IDockerNetworkSettings;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerContainerState;
import org.eclipse.linuxtools.internal.docker.core.DockerHostConfig;
import org.eclipse.linuxtools.internal.docker.core.DockerNetworkSettings;

public class DockerContainerInfo
implements IDockerContainerInfo {
    private String id;
    private Date created;
    private String path;
    private List<String> args;
    private IDockerContainerConfig config;
    private IDockerHostConfig hostConfig;
    private IDockerContainerState state;
    private String image;
    private IDockerNetworkSettings networkSettings;
    private String resolvConfPath;
    private String hostnamePath;
    private String hostsPath;
    private String name;
    private String driver;
    private String execDriver;
    private String processLabel;
    private String mountLabel;
    private Map<String, String> volumes;
    private Map<String, Boolean> volumesRW;

    public DockerContainerInfo(ContainerInfo info) {
        this.id = info.id();
        this.created = info.created();
        this.path = info.path();
        this.args = info.args();
        this.config = new DockerContainerConfig(info.config());
        this.hostConfig = new DockerHostConfig(info.hostConfig());
        this.state = new DockerContainerState(info.state());
        this.image = info.image();
        this.networkSettings = new DockerNetworkSettings(info.networkSettings());
        this.resolvConfPath = info.resolvConfPath();
        this.hostnamePath = info.hostnamePath();
        this.hostsPath = info.hostsPath();
        this.name = info.name();
        this.driver = info.driver();
        this.execDriver = info.execDriver();
        this.processLabel = info.processLabel();
        this.mountLabel = info.mountLabel();
        this.volumes = info.volumes();
        this.volumesRW = info.volumesRW();
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public Date created() {
        return this.created == null ? null : new Date(this.created.getTime());
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public List<String> args() {
        return this.args;
    }

    @Override
    public IDockerContainerConfig config() {
        return this.config;
    }

    @Override
    public IDockerHostConfig hostConfig() {
        return this.hostConfig;
    }

    @Override
    public IDockerContainerState state() {
        return this.state;
    }

    @Override
    public String image() {
        return this.image;
    }

    @Override
    public IDockerNetworkSettings networkSettings() {
        return this.networkSettings;
    }

    @Override
    public String resolvConfPath() {
        return this.resolvConfPath;
    }

    @Override
    public String hostnamePath() {
        return this.hostnamePath;
    }

    @Override
    public String hostsPath() {
        return this.hostsPath;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String driver() {
        return this.driver;
    }

    @Override
    public String execDriver() {
        return this.execDriver;
    }

    @Override
    public String processLabel() {
        return this.processLabel;
    }

    @Override
    public String mountLabel() {
        return this.mountLabel;
    }

    @Override
    public Map<String, String> volumes() {
        return this.volumes;
    }

    @Override
    public Map<String, Boolean> volumesRW() {
        return this.volumesRW;
    }
}

