/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.filters;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;

public class NewHandlerChainViewerFilter
extends ViewerFilter {
    private static final String XML_FILE_EXTENSION = "xml";
    private IJavaProject javaProject;
    private boolean filterFiles;
    private boolean filterCompilationUnits;

    public NewHandlerChainViewerFilter(IJavaProject javaProject, boolean filterFiles, boolean filterCompilationUnits) {
        this.javaProject = javaProject;
        this.filterFiles = filterFiles;
        this.filterCompilationUnits = filterCompilationUnits;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        block9: {
            block8: {
                if (!(element instanceof IJavaProject)) break block8;
                if (this.javaProject != null) {
                    return this.javaProject.equals(element);
                }
                return false;
            }
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot packageFragmentRoot = (IPackageFragmentRoot)element;
                return packageFragmentRoot.getKind() == 1;
            }
            if (!(element instanceof IPackageFragment)) break block9;
            return true;
        }
        try {
            ICompilationUnit compilationUnit;
            IType type;
            if (!this.filterFiles && element instanceof IFile) {
                IFile file = (IFile)element;
                return file.isAccessible() && file.getFileExtension().equals(XML_FILE_EXTENSION);
            }
            if (!this.filterCompilationUnits && element instanceof ICompilationUnit && (type = (compilationUnit = (ICompilationUnit)element).findPrimaryType()) != null) {
                return type.isClass() || type.isInterface() && !type.isAnnotation();
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme);
        }
        return false;
    }
}

