/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.Observable;

public final class ObservableList<E>
extends AbstractList<E>
implements Observable {
    private final List<E> base;
    private ListenerContext listeners;

    public ObservableList() {
        this(null);
    }

    public ObservableList(List<E> base) {
        this.base = base == null ? new ArrayList() : base;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ObservableList observableList = this;
        synchronized (observableList) {
            if (this.listeners == null) {
                this.listeners = new ListenerContext();
            }
            this.listeners.attach(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ObservableList observableList = this;
        synchronized (observableList) {
            if (this.listeners != null) {
                this.listeners.detach(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void broadcast() {
        ListenerContext listeners;
        ObservableList observableList = this;
        synchronized (observableList) {
            listeners = this.listeners;
        }
        if (listeners != null) {
            listeners.broadcast(new Event());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object obj) {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.contains(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.containsAll(collection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(Object obj) {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.indexOf(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int lastIndexOf(Object obj) {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.lastIndexOf(obj);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<E> iterator() {
        ObservableList observableList = this;
        synchronized (observableList) {
            return new Iterator<E>(){
                private final Iterator<E> base;
                {
                    this.base = ObservableList.this.base.iterator();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean hasNext() {
                    ObservableList observableList = ObservableList.this;
                    synchronized (observableList) {
                        return this.base.hasNext();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public E next() {
                    ObservableList observableList = ObservableList.this;
                    synchronized (observableList) {
                        return this.base.next();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void remove() {
                    ObservableList observableList = ObservableList.this;
                    synchronized (observableList) {
                        this.base.remove();
                        ObservableList.this.broadcast();
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object[] toArray() {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T[] toArray(T[] array) {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.toArray(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E get(int index) {
        ObservableList observableList = this;
        synchronized (observableList) {
            return this.base.get(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E set(int index, E entry) {
        boolean modified;
        E previous;
        ObservableList observableList = this;
        synchronized (observableList) {
            previous = this.base.set(index, entry);
            modified = previous != entry;
        }
        if (modified) {
            this.broadcast();
        }
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(E entry) {
        boolean modified;
        ObservableList observableList = this;
        synchronized (observableList) {
            modified = this.base.add(entry);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(int index, E entry) {
        ObservableList observableList = this;
        synchronized (observableList) {
            this.base.add(index, entry);
        }
        this.broadcast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean modified;
        ObservableList observableList = this;
        synchronized (observableList) {
            modified = this.base.addAll(collection);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        boolean modified;
        ObservableList observableList = this;
        synchronized (observableList) {
            modified = this.base.addAll(index, collection);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E remove(int index) {
        E removed;
        ObservableList observableList = this;
        synchronized (observableList) {
            removed = this.base.remove(index);
        }
        this.broadcast();
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object obj) {
        boolean modified;
        ObservableList observableList = this;
        synchronized (observableList) {
            modified = this.base.remove(obj);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified;
        ObservableList observableList = this;
        synchronized (observableList) {
            modified = this.base.removeAll(collection);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified;
        ObservableList observableList = this;
        synchronized (observableList) {
            modified = this.base.retainAll(collection);
        }
        if (modified) {
            this.broadcast();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        boolean broadcast = false;
        ObservableList observableList = this;
        synchronized (observableList) {
            if (!this.base.isEmpty()) {
                broadcast = true;
            }
            this.base.clear();
        }
        if (broadcast) {
            this.broadcast();
        }
    }
}

