/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementData;
import org.eclipse.sapphire.ElementHandle;
import org.eclipse.sapphire.ElementList;
import org.eclipse.sapphire.ElementProperty;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.EventDeliveryJob;
import org.eclipse.sapphire.Filter;
import org.eclipse.sapphire.ImpliedElementProperty;
import org.eclipse.sapphire.InitialValueService;
import org.eclipse.sapphire.JobQueue;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.ListenerContext;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.LoggingService;
import org.eclipse.sapphire.MasterConversionService;
import org.eclipse.sapphire.Property;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.PropertyEvent;
import org.eclipse.sapphire.PropertyVisitor;
import org.eclipse.sapphire.ReferenceValue;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Sapphire;
import org.eclipse.sapphire.Suspension;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.Transient;
import org.eclipse.sapphire.TransientProperty;
import org.eclipse.sapphire.Value;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.internal.NonSuspendableListener;
import org.eclipse.sapphire.modeling.ElementDisposeEvent;
import org.eclipse.sapphire.modeling.ElementEvent;
import org.eclipse.sapphire.modeling.ModelPath;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.modeling.annotations.Reference;
import org.eclipse.sapphire.modeling.localization.LocalizationService;
import org.eclipse.sapphire.modeling.localization.SourceLanguageLocalizationService;
import org.eclipse.sapphire.services.EqualityService;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.internal.ElementInstanceServiceContext;
import org.eclipse.sapphire.util.MapFactory;
import org.eclipse.sapphire.util.MutableReference;
import org.eclipse.sapphire.util.SetFactory;
import org.eclipse.sapphire.util.SortedSetFactory;

public abstract class ElementImpl
implements Element {
    @Text(value="{0} element is already disposed.")
    private static LocalizableText elementAlreadyDisposed;
    @Text(value="Path \"{1}\" is invalid for {0}.")
    private static LocalizableText illegalPathException;
    private static final Comparator<Property> PROPERTY_INSTANCE_COMPARATOR;
    private final ElementType type;
    private final Property parent;
    private final Resource resource;
    private final SortedSet<Property> properties;
    private final Map<String, Property> propertiesByName;
    private ListenerContext listeners;
    private ElementInstanceServiceContext elementServiceContext;
    private boolean disposed = false;

    static {
        LocalizableText.init(ElementImpl.class);
        PROPERTY_INSTANCE_COMPARATOR = new Comparator<Property>(){

            @Override
            public int compare(Property x, Property y) {
                return x.name().compareToIgnoreCase(y.name());
            }
        };
    }

    public ElementImpl(ElementType type, Property parent, Resource resource) {
        this.type = type;
        this.parent = parent;
        this.resource = resource;
        SortedSetFactory<Property> propertiesSetFactory = SortedSetFactory.start(PROPERTY_INSTANCE_COMPARATOR);
        MapFactory propertiesByNameMapFactory = MapFactory.start();
        for (PropertyDef property : this.type.properties()) {
            Property instance;
            if (property instanceof ValueProperty) {
                ValueProperty p = (ValueProperty)property;
                instance = property.hasAnnotation(Reference.class) ? new ReferenceValue((Element)this, p) : new Value((Element)this, p);
            } else if (property instanceof TransientProperty) {
                instance = new Transient((Element)this, (TransientProperty)property);
            } else if (property instanceof ElementProperty) {
                instance = new ElementHandle((Element)this, (ElementProperty)property);
            } else if (property instanceof ListProperty) {
                instance = new ElementList((Element)this, (ListProperty)property);
            } else {
                throw new IllegalStateException();
            }
            propertiesSetFactory.add(instance);
            propertiesByNameMapFactory.add(property.name().toLowerCase(), instance);
        }
        this.properties = propertiesSetFactory.result();
        this.propertiesByName = propertiesByNameMapFactory.result();
        resource.init(this);
        for (Listener listener : this.type.listeners()) {
            this.attach(listener);
        }
    }

    @Override
    public final Resource resource() {
        return this.resource;
    }

    @Override
    public final Element root() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.root();
    }

    @Override
    public final Property parent() {
        return this.parent;
    }

    @Override
    public final boolean holds(Element element) {
        if (element == null) {
            throw new IllegalArgumentException();
        }
        Property p = element.parent();
        while (p != null) {
            if (this == p.element()) {
                return true;
            }
            p = p.element().parent();
        }
        return false;
    }

    @Override
    public final boolean holds(Property property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Property p = property;
        while (p != null) {
            if (this == p.element()) {
                return true;
            }
            p = p.element().parent();
        }
        return false;
    }

    @Override
    public final <T> T nearest(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        if (this.parent != null) {
            return this.parent.element().nearest(type);
        }
        return null;
    }

    @Override
    public ElementType type() {
        return this.type;
    }

    @Override
    public final <T extends Element> T initialize() {
        for (Property instance : this.properties()) {
            PropertyDef property = instance.definition();
            if (property instanceof ValueProperty) {
                InitialValueService initialValueService = instance.service(InitialValueService.class);
                if (initialValueService == null) continue;
                ((Value)instance).write(initialValueService.value());
                continue;
            }
            if (!(property instanceof ImpliedElementProperty)) continue;
            this.property((ImpliedElementProperty)property).content().initialize();
        }
        return (T)this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SortedSet<Property> properties() {
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            return this.properties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Property> properties(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            return this.properties(new ModelPath(path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Property> properties(ModelPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            final SetFactory properties = SetFactory.start();
            this.visit(path, new PropertyVisitor(){

                @Override
                public boolean visit(Property property) {
                    properties.add(property);
                    return true;
                }
            });
            return properties.result();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Property property(String path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            Property property = this.propertiesByName.get(path.toLowerCase());
            if (property == null) {
                property = this.property(new ModelPath(path));
            }
            return property;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Property property(ModelPath path) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            final MutableReference result = new MutableReference();
            this.visit(path, new PropertyVisitor(){

                @Override
                public boolean visit(Property property) {
                    result.set(property);
                    return false;
                }
            });
            return (Property)result.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Property property(PropertyDef property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            Property instance = this.property(property.name());
            if (instance == null) {
                throw new IllegalArgumentException();
            }
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Value<T> property(ValueProperty property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            return (Value)this.property((PropertyDef)property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> Transient<T> property(TransientProperty property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            return (Transient)this.property((PropertyDef)property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends Element> ElementHandle<T> property(ElementProperty property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            return (ElementHandle)this.property((PropertyDef)property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T extends Element> ElementList<T> property(ListProperty property) {
        if (property == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            return (ElementList)this.property((PropertyDef)property);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final SortedSet<Property> content() {
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            SortedSetFactory<Property> contentSetFactory = SortedSetFactory.start(PROPERTY_INSTANCE_COMPARATOR);
            for (Property property : this.properties) {
                if (property.empty()) continue;
                contentSetFactory.add(property);
            }
            return contentSetFactory.result();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean visit(String path, PropertyVisitor visitor) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            return this.visit(new ModelPath(path), visitor);
        }
    }

    @Override
    public final boolean visit(ModelPath path, PropertyVisitor visitor) {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (visitor == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            try {
                block32: {
                    Property parent;
                    ModelPath.Segment head;
                    block33: {
                        block35: {
                            ModelPath tail;
                            Property property;
                            block34: {
                                block31: {
                                    this.assertNotDisposed();
                                    head = path.head();
                                    if (path.length() != 1) break block31;
                                    if (head instanceof ModelPath.PropertySegment) {
                                        String name = ((ModelPath.PropertySegment)head).getPropertyName();
                                        Property property2 = this.propertiesByName.get(name.toLowerCase());
                                        if (property2 != null) {
                                            return visitor.visit(property2);
                                        }
                                        return true;
                                    }
                                    if (head instanceof ModelPath.AllDescendentsSegment) {
                                        for (Property property3 : this.properties()) {
                                            if (!visitor.visit(property3)) {
                                                return false;
                                            }
                                            if (property3 instanceof ElementHandle) {
                                                Object element2 = ((ElementHandle)property3).content();
                                                if (element2 == null || element2.visit(path, visitor)) continue;
                                                return false;
                                            }
                                            if (!(property3 instanceof ElementList)) continue;
                                            for (Object element2 : (ElementList)property3) {
                                                if (element2.visit(path, visitor)) continue;
                                                return false;
                                            }
                                        }
                                        return true;
                                    }
                                    break block32;
                                }
                                if (head instanceof ModelPath.ModelRootSegment) {
                                    return this.root().visit(path.tail(), visitor);
                                }
                                if (head instanceof ModelPath.ParentElementSegment) {
                                    Property parent2 = this.parent();
                                    if (parent2 != null) {
                                        return parent2.element().visit(path.tail(), visitor);
                                    }
                                    return true;
                                }
                                if (!(head instanceof ModelPath.PropertySegment)) break block33;
                                String name = ((ModelPath.PropertySegment)head).getPropertyName();
                                property = this.propertiesByName.get(name.toLowerCase());
                                tail = path.tail();
                                if (!(property instanceof ElementHandle)) break block34;
                                Object element3 = ((ElementHandle)property).content();
                                if (element3 != null) {
                                    return element3.visit(tail, visitor);
                                }
                                break block35;
                            }
                            if (!(property instanceof ElementList)) break;
                            for (Element element4 : (ElementList)property) {
                                if (element4.visit(tail, visitor)) continue;
                                return false;
                            }
                            break;
                        }
                    }
                    if (head instanceof ModelPath.TypeFilterSegment) {
                        String t = this.type().getSimpleName();
                        boolean match = false;
                        for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                            if (!type.equalsIgnoreCase(t)) continue;
                            match = true;
                            break;
                        }
                        if (match) {
                            return this.visit(path.tail(), visitor);
                        }
                        return true;
                    }
                    if (head instanceof ModelPath.AllSiblingsSegment && (parent = this.parent()) instanceof ElementList) {
                        ModelPath p = new ModelPath(parent.name()).append(path.tail());
                        return parent.element().visit(p, visitor);
                    }
                }
                throw new IllegalArgumentException(path.toString());
            }
            finally {
                Throwable throwable;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh() {
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            for (Property property : this.properties()) {
                if (this.disposed()) break;
                property.refresh();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean empty() {
        Element element = this.root();
        synchronized (element) {
            Property property;
            this.assertNotDisposed();
            Iterator iterator = this.properties.iterator();
            do {
                if (iterator.hasNext()) continue;
                return true;
            } while ((property = (Property)iterator.next()).empty());
            return false;
        }
    }

    @Override
    public final void clear() {
        this.assertNotDisposed();
        for (Property property : this.properties()) {
            property.clear();
        }
    }

    @Override
    public final void copy(Element source) {
        this.assertNotDisposed();
        if (source == null) {
            throw new IllegalArgumentException();
        }
        for (Property property : this.properties()) {
            if (property.definition().isReadOnly()) continue;
            property.copy(source);
        }
    }

    @Override
    public final void copy(ElementData source) {
        this.assertNotDisposed();
        if (source == null) {
            throw new IllegalArgumentException();
        }
        for (Property property : this.properties()) {
            if (property.definition().isReadOnly()) continue;
            property.copy(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean equals(Object obj) {
        Element element = this.root();
        synchronized (element) {
            EqualityService equalityService;
            boolean result = false;
            if (this == obj) {
                result = true;
            } else if (obj instanceof Element && !this.disposed() && (equalityService = this.service(EqualityService.class)) != null) {
                result = equalityService.doEquals(obj);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int hashCode() {
        Element element = this.root();
        synchronized (element) {
            EqualityService equalityService;
            int result = this.disposed() ? super.hashCode() : ((equalityService = this.service(EqualityService.class)) != null ? equalityService.doHashCode() : super.hashCode());
            return result;
        }
    }

    @Override
    public final <S extends Service> S service(Class<S> type) {
        this.assertNotDisposed();
        if (type == null) {
            throw new IllegalArgumentException();
        }
        List<S> services = this.services(type);
        return (S)(services.isEmpty() ? null : (Service)services.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <S extends Service> List<S> services(Class<S> type) {
        this.assertNotDisposed();
        if (type == null) {
            throw new IllegalArgumentException();
        }
        Element element = this.root();
        synchronized (element) {
            if (this.elementServiceContext == null) {
                this.elementServiceContext = new ElementInstanceServiceContext(this);
            }
            return this.elementServiceContext.services(type);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Status validation() {
        Element element = this.root();
        synchronized (element) {
            this.assertNotDisposed();
            Status.CompositeStatusFactory factory = Status.factoryForComposite();
            for (Property property : this.properties()) {
                if (!property.enabled()) continue;
                factory.merge(property.validation());
                if (property instanceof ElementHandle) {
                    Object child = ((ElementHandle)property).content();
                    if (child == null) continue;
                    factory.merge(child.validation());
                    continue;
                }
                if (!(property instanceof ElementList)) continue;
                for (Object child : (ElementList)property) {
                    factory.merge(child.validation());
                }
            }
            return factory.create();
        }
    }

    public JobQueue<EventDeliveryJob> queue() {
        return ((ElementImpl)this.root()).listeners(true).queue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ListenerContext listeners(boolean createIfNecessary) {
        Element root;
        Element element = root = this.root();
        synchronized (element) {
            if (this.listeners == null && createIfNecessary) {
                this.assertNotDisposed();
                this.listeners = new ListenerContext(this == root ? null : ((ElementImpl)root).listeners(true).queue());
            }
            return this.listeners;
        }
    }

    @Override
    public final void attach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        this.listeners(true).attach(listener);
    }

    @Override
    public final void attach(Listener listener, String path) {
        this.assertNotDisposed();
        this.attach(listener, new ModelPath(path));
    }

    @Override
    public final void attach(Listener listener, ModelPath path) {
        this.assertNotDisposed();
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.ModelRootSegment) {
            this.root().attach(listener, path.tail());
        } else if (head instanceof ModelPath.ParentElementSegment) {
            Property parent = this.parent();
            if (parent == null) {
                throw this.createIllegalPathException(path);
            }
            parent.element().attach(listener, path.tail());
        } else if (head instanceof ModelPath.AllSiblingsSegment) {
            Property parent = this.parent();
            if (parent == null || !(parent.definition() instanceof ListProperty)) {
                throw this.createIllegalPathException(path);
            }
            ModelPath p = new ModelPath(parent.name()).append(path.tail());
            parent.element().attach(listener, p);
        } else if (head instanceof ModelPath.TypeFilterSegment) {
            String t = this.type.getSimpleName();
            boolean match = false;
            for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                if (!type.equalsIgnoreCase(t)) continue;
                match = true;
                break;
            }
            if (match) {
                this.attach(listener, path.tail());
            }
        } else if (head instanceof ModelPath.AllDescendentsSegment) {
            for (Property property : this.properties()) {
                property.attach(listener, path);
            }
        } else if (head instanceof ModelPath.PropertySegment) {
            String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
            Property property = this.property(propertyName);
            if (property == null) {
                throw this.createIllegalPathException(path);
            }
            property.attach(listener, path.tail());
        }
    }

    @Override
    public final void detach(Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException();
        }
        ListenerContext listeners = this.listeners(false);
        if (listeners != null) {
            listeners.detach(listener);
        }
    }

    @Override
    public final void detach(Listener listener, String path) {
        if (this.disposed()) {
            return;
        }
        this.detach(listener, new ModelPath(path));
    }

    @Override
    public final void detach(Listener listener, ModelPath path) {
        if (this.disposed()) {
            return;
        }
        ModelPath.Segment head = path.head();
        if (head instanceof ModelPath.ModelRootSegment) {
            this.root().detach(listener, path.tail());
        } else if (head instanceof ModelPath.ParentElementSegment) {
            Property parent = this.parent();
            if (parent == null) {
                throw this.createIllegalPathException(path);
            }
            parent.element().detach(listener, path.tail());
        } else if (head instanceof ModelPath.AllSiblingsSegment) {
            Property parent = this.parent();
            if (parent == null || !(parent.definition() instanceof ListProperty)) {
                throw this.createIllegalPathException(path);
            }
            ModelPath p = new ModelPath(parent.name()).append(path.tail());
            parent.element().detach(listener, p);
        } else if (head instanceof ModelPath.TypeFilterSegment) {
            String t = this.type.getSimpleName();
            boolean match = false;
            for (String type : ((ModelPath.TypeFilterSegment)head).getTypes()) {
                if (!type.equalsIgnoreCase(t)) continue;
                match = true;
                break;
            }
            if (match) {
                this.detach(listener, path.tail());
            }
        } else if (head instanceof ModelPath.AllDescendentsSegment) {
            for (Property property : this.properties()) {
                property.detach(listener, path);
            }
        } else if (head instanceof ModelPath.PropertySegment) {
            String propertyName = ((ModelPath.PropertySegment)head).getPropertyName();
            Property property = this.property(propertyName);
            if (property == null) {
                throw this.createIllegalPathException(path);
            }
            property.detach(listener, path.tail());
        }
    }

    protected final void post(Event event) {
        ListenerContext listeners;
        if (event != null && (listeners = this.listeners(false)) != null) {
            listeners.post(event);
        }
    }

    protected final void broadcast() {
        ListenerContext listeners = this.listeners(false);
        if (listeners != null) {
            listeners.broadcast();
        }
    }

    protected final void broadcast(Event event) {
        ListenerContext listeners;
        if (event != null && (listeners = this.listeners(false)) != null) {
            listeners.broadcast(event);
        }
    }

    @Override
    public final Suspension suspend() {
        final JobQueue<EventDeliveryJob> queue = this.listeners(true).queue();
        final Suspension suspension = queue.suspend(new SuspendFilter());
        return new Suspension(){

            @Override
            public void dispose() {
                suspension.dispose();
                queue.process();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean disposed() {
        Element element = this.root();
        synchronized (element) {
            return this.disposed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void dispose() {
        Element element = this.root();
        synchronized (element) {
            if (!this.disposed) {
                this.disposed = true;
                this.broadcast(new ElementDisposeEvent(this));
                if (this.elementServiceContext != null) {
                    this.elementServiceContext.dispose();
                }
                for (Property property : this.properties) {
                    property.dispose();
                }
                try {
                    this.resource().dispose();
                }
                catch (Exception e) {
                    Sapphire.service(LoggingService.class).log(e);
                }
                this.listeners = null;
            }
        }
    }

    @Override
    public final void close() {
        this.dispose();
    }

    protected final void assertNotDisposed() {
        if (this.disposed()) {
            String msg = elementAlreadyDisposed.format(this.type.getSimpleName());
            throw new IllegalStateException(msg);
        }
    }

    private final IllegalArgumentException createIllegalPathException(ModelPath path) {
        String message = illegalPathException.format(this.type.getModelElementClass().getName(), path.toString());
        return new IllegalArgumentException(message);
    }

    @Override
    public <A> A adapt(Class<A> adapterType) {
        this.assertNotDisposed();
        A result = this.service(MasterConversionService.class).convert(this, adapterType);
        if (result == null) {
            if (this.resource != null) {
                result = this.resource.adapt(adapterType);
            }
            if (result == null && this.parent != null) {
                result = this.parent.element().adapt(adapterType);
            }
            if (result == null && adapterType == LocalizationService.class) {
                result = adapterType.cast(SourceLanguageLocalizationService.INSTANCE);
            }
        }
        return result;
    }

    protected static final boolean equal(String value1, String value2) {
        String val1 = ElementImpl.normalize(value1);
        String val2 = ElementImpl.normalize(value2);
        boolean valuesAreEqual = false;
        if (val1 == val2) {
            valuesAreEqual = true;
        } else if (val1 != null && val2 != null) {
            valuesAreEqual = val1.equals(val2);
        }
        return valuesAreEqual;
    }

    protected static final String normalize(String value) {
        if (value != null && value.equals("")) {
            return null;
        }
        return value;
    }

    private final class SuspendFilter
    implements Filter<EventDeliveryJob> {
        private SuspendFilter() {
        }

        @Override
        public boolean allows(EventDeliveryJob job) {
            if (!(job.listener() instanceof NonSuspendableListener)) {
                Event event = job.event();
                if (event instanceof PropertyEvent) {
                    return !ElementImpl.this.holds(((PropertyEvent)event).property());
                }
                if (event instanceof ElementEvent) {
                    return !ElementImpl.this.holds(((ElementEvent)event).element());
                }
            }
            return true;
        }
    }
}

