/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.view.servers;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.ServerUICore;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.cnf.ServerDecorator;
import org.eclipse.wst.server.ui.internal.provisional.UIDecoratorManager;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.eclipse.wst.server.ui.internal.view.servers.ServerTableViewer;
import org.eclipse.wst.server.ui.internal.viewers.AbstractTreeContentProvider;
import org.eclipse.wst.server.ui.internal.viewers.BaseCellLabelProvider;

public class ServerTableLabelProvider
extends BaseCellLabelProvider {
    public static final String[] syncState = new String[]{Messages.viewSyncOkay, Messages.viewSyncRestart, Messages.viewSyncPublish, Messages.viewSyncRestartPublish, Messages.viewSyncPublishing};
    public static final String[] syncStateUnmanaged = new String[]{Messages.viewSyncOkay2, Messages.viewSyncRestart2, Messages.viewSyncPublish2, Messages.viewSyncRestartPublish2, Messages.viewSyncPublishing2};
    private static final String[] modulePublishState = new String[]{"", Messages.viewSyncOkay, Messages.viewSyncPublish, Messages.viewSyncPublish};
    private int count = 0;
    protected IServer defaultServer;

    public ServerTableLabelProvider() {
        super(null);
    }

    public void setDefaultServer(IServer ds) {
        this.defaultServer = ds;
    }

    public IServer getDefaultServer() {
        return this.defaultServer;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof AbstractTreeContentProvider.TreeElement) {
            if (columnIndex == 0) {
                ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
                return sharedImages.getImage("IMG_OBJ_FOLDER");
            }
            return null;
        }
        if (element instanceof ModuleServer) {
            IStatus status;
            ModuleServer ms = (ModuleServer)element;
            if (columnIndex == 0) {
                Image dec;
                ILabelProvider labelProvider = ServerUICore.getLabelProvider();
                Image image = labelProvider.getImage((Object)ms.module[ms.module.length - 1]);
                labelProvider.dispose();
                if (this.decorator != null && (dec = this.decorator.decorateImage(image, (Object)ms)) != null) {
                    return dec;
                }
                return image;
            }
            if (columnIndex == 1) {
                if (ms.server == null) {
                    return null;
                }
                return this.getStateImage(ms.server.getServerType(), ms.server.getModuleState(ms.module), null);
            }
            if (columnIndex == 2 && (status = ((Server)ms.server).getModuleStatus(ms.module)) != null) {
                ISharedImages sharedImages = ServerUIPlugin.getInstance().getWorkbench().getSharedImages();
                if (status.getSeverity() == 4) {
                    return sharedImages.getImage("IMG_OBJS_ERROR_TSK");
                }
                if (status.getSeverity() == 2) {
                    return sharedImages.getImage("IMG_OBJS_WARN_TSK");
                }
                if (status.getSeverity() == 1) {
                    return sharedImages.getImage("IMG_OBJS_INFO_TSK");
                }
            }
            return null;
        }
        IServer server = (IServer)element;
        if (columnIndex == 0) {
            if (server.getServerType() != null) {
                Image dec;
                Image image = ImageResource.getImage(server.getServerType().getId());
                if (this.decorator != null && (dec = this.decorator.decorateImage(image, (Object)server)) != null) {
                    return dec;
                }
                return image;
            }
            return null;
        }
        if (columnIndex == 1) {
            IServerType serverType = server.getServerType();
            if (serverType == null) {
                return null;
            }
            return this.getServerStateImage(server);
        }
        return null;
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof AbstractTreeContentProvider.TreeElement) {
            if (columnIndex == 0) {
                return ((AbstractTreeContentProvider.TreeElement)element).text;
            }
            return "";
        }
        if (element instanceof ModuleServer) {
            ModuleServer ms = (ModuleServer)element;
            if (columnIndex == 0) {
                String dec;
                if (ms.module == null) {
                    return "";
                }
                int size = ms.module.length;
                String name = ms.module[size - 1].getName();
                if (this.decorator != null && (dec = this.decorator.decorateText(name, (Object)ms)) != null) {
                    return dec;
                }
                return name;
            }
            if (columnIndex == 1) {
                if (ms.server == null) {
                    return "";
                }
                return this.getStateLabel(ms.server.getServerType(), ms.server.getModuleState(ms.module), null);
            }
            if (columnIndex == 2) {
                IStatus status = ((Server)ms.server).getModuleStatus(ms.module);
                if (status != null) {
                    return status.getMessage();
                }
                return modulePublishState[ms.server.getModulePublishState(ms.module)];
            }
        }
        IServer server = (IServer)element;
        if (columnIndex == 0) {
            return this.notNull(server.getName());
        }
        if (columnIndex == 1) {
            IServerType serverType = server.getServerType();
            if (serverType != null) {
                return this.getServerStateLabel(server);
            }
            return "";
        }
        if (columnIndex == 2) {
            IStatus status = ((Server)server).getServerStatus();
            if (status != null) {
                return status.getMessage();
            }
            if (server.getServerType() == null) {
                return "";
            }
            if (server.getServerState() == 0) {
                return "";
            }
            String serverId = server.getId();
            if (ServerTableViewer.publishing.contains(serverId)) {
                return syncState[4];
            }
            int i = 0;
            if (server.shouldPublish()) {
                if (((Server)server).isPublishUnknown()) {
                    return "";
                }
                i += 2;
            }
            if (server.shouldRestart()) {
                i = 1;
            }
            return syncState[i];
        }
        return "-";
    }

    protected String notNull(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    protected Image getServerStateImage(IServer server) {
        return this.getStateImage(server.getServerType(), server.getServerState(), server.getMode());
    }

    protected Image getStateImage(IServerType serverType, int state, String mode) {
        return UIDecoratorManager.getUIDecorator(serverType).getStateImage(state, mode, this.count);
    }

    protected String getServerStateLabel(IServer server) {
        return ServerDecorator.getServerStateLabel(server);
    }

    protected String getStateLabel(IServerType serverType, int state, String mode) {
        return UIDecoratorManager.getUIDecorator(serverType).getStateLabel(state, mode, this.count);
    }

    protected void animate() {
        ++this.count;
        if (this.count > 2) {
            this.count = 0;
        }
    }
}

