/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.swt.xml.editor;

import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.sapphire.Context;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.ElementType;
import org.eclipse.sapphire.LocalizableText;
import org.eclipse.sapphire.Resource;
import org.eclipse.sapphire.Text;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.modeling.xml.RootXmlResource;
import org.eclipse.sapphire.modeling.xml.XmlResourceStore;
import org.eclipse.sapphire.osgi.BundleBasedContext;
import org.eclipse.sapphire.ui.SapphireEditor;
import org.eclipse.sapphire.ui.def.DefinitionLoader;
import org.eclipse.sapphire.ui.def.EditorPageDef;
import org.eclipse.sapphire.ui.swt.xml.editor.XmlEditorResourceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public class SapphireEditorForXml
extends SapphireEditor
implements IExecutableExtension {
    @Text(value="Source")
    private static LocalizableText sourcePageTitle;
    private ElementType type;
    private DefinitionLoader.Reference<EditorPageDef> definition;
    private StructuredTextEditor sourcePage;
    private Context context;
    private String sdef;
    private String pageName;
    private String pageDefinitionId;

    static {
        LocalizableText.init(SapphireEditorForXml.class);
    }

    public SapphireEditorForXml(ElementType type, DefinitionLoader.Reference<EditorPageDef> definition) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.definition = definition;
    }

    public SapphireEditorForXml() {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) {
        super.setInitializationData(config, propertyName, data);
        if (this.definition == null) {
            Map properties = (Map)data;
            this.context = BundleBasedContext.adapt((String)config.getContributor().getName());
            this.sdef = (String)properties.get("sdef");
            this.pageName = (String)properties.get("pageName");
            this.pageDefinitionId = (String)properties.get("pageDefinitionId");
        }
    }

    protected DefinitionLoader getDefinitionLoader() {
        return DefinitionLoader.context((Context)this.context).sdef(this.sdef);
    }

    protected DefinitionLoader.Reference<EditorPageDef> getDefinition(String id) {
        if (this.definition != null) {
            return this.definition;
        }
        return super.getDefinition(id);
    }

    public final StructuredTextEditor getXmlEditor() {
        return this.sourcePage;
    }

    protected Element createModel() {
        ElementType type = this.type;
        if (type == null) {
            EditorPageDef def = (EditorPageDef)this.getDefinition(this.pageDefinitionId).resolve();
            if (def == null) {
                throw new IllegalStateException();
            }
            JavaType elementJavaType = (JavaType)def.getElementType().target();
            type = ElementType.read((Class)((Class)elementJavaType.artifact()), (boolean)true);
        }
        XmlEditorResourceStore store = this.createResourceStore(this.sourcePage);
        return type.instantiate((Resource)new RootXmlResource((XmlResourceStore)store));
    }

    protected XmlEditorResourceStore createResourceStore(StructuredTextEditor sourceEditor) {
        return new XmlEditorResourceStore(this, this.sourcePage);
    }

    protected final void createSourcePages() throws PartInitException {
        this.sourcePage = new StructuredTextEditor();
        this.sourcePage.setEditorPart((IEditorPart)this);
        int index = this.addPage((IEditorPart)this.sourcePage, this.getEditorInput());
        this.setPageText(index, sourcePageTitle.text());
    }

    protected void createFormPages() throws PartInitException {
        if (this.pageName == null) {
            IEditorPart page = this.createPage(this.getDefinition(null));
            if (page instanceof IFormPage) {
                this.addPage(0, (IFormPage)page);
            } else {
                this.addPage(0, page, this.getEditorInput());
            }
        } else {
            this.addDeferredPage(0, this.pageName, this.pageDefinitionId);
        }
    }

    public IContentOutlinePage getContentOutline(Object page) {
        if (page == this.sourcePage) {
            return (IContentOutlinePage)this.sourcePage.getAdapter(IContentOutlinePage.class);
        }
        return super.getContentOutline(page);
    }

    public void dispose() {
        super.dispose();
        this.type = null;
        this.definition = null;
        this.sourcePage = null;
    }
}

