/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui.forms;

import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.FilteredListener;
import org.eclipse.sapphire.Listener;
import org.eclipse.sapphire.modeling.Status;
import org.eclipse.sapphire.ui.PartValidationEvent;
import org.eclipse.sapphire.ui.SapphirePart;
import org.eclipse.sapphire.ui.forms.FormComponentPart;
import org.eclipse.sapphire.ui.forms.TabGroupDef;
import org.eclipse.sapphire.ui.forms.TabGroupPageDef;
import org.eclipse.sapphire.ui.forms.TabGroupPagePart;
import org.eclipse.sapphire.ui.forms.swt.FormComponentPresentation;
import org.eclipse.sapphire.ui.forms.swt.SwtPresentation;
import org.eclipse.sapphire.ui.forms.swt.internal.TabGroupPresentation;
import org.eclipse.sapphire.util.ListFactory;
import org.eclipse.swt.widgets.Composite;

public final class TabGroupPart
extends FormComponentPart {
    private List<TabGroupPagePart> pages;
    private TabGroupPagePart selection;

    @Override
    protected void init() {
        super.init();
        Element element = this.getModelElement();
        ListFactory pagesListFactory = ListFactory.start();
        FilteredListener<PartValidationEvent> tabPartListener = new FilteredListener<PartValidationEvent>(){

            protected void handleTypedEvent(PartValidationEvent event) {
                TabGroupPart.this.refreshValidation();
            }
        };
        for (TabGroupPageDef pageDef : this.definition().getTabs()) {
            TabGroupPagePart pagePart = new TabGroupPagePart();
            pagePart.init(this, element, pageDef, this.params);
            pagePart.initialize();
            pagePart.attach((Listener)tabPartListener);
            pagesListFactory.add((Object)pagePart);
        }
        this.pages = pagesListFactory.result();
        this.selection = this.pages.get(0);
    }

    @Override
    public TabGroupDef definition() {
        return (TabGroupDef)super.definition();
    }

    public List<TabGroupPagePart> pages() {
        return this.pages;
    }

    public TabGroupPagePart selection() {
        return this.selection;
    }

    public void select(TabGroupPagePart page) {
        if (page == null) {
            throw new IllegalArgumentException();
        }
        this.selection = page;
        this.selection.setFocus();
    }

    @Override
    protected Status computeValidation() {
        Status.CompositeStatusFactory factory = Status.factoryForComposite();
        for (TabGroupPagePart page : this.pages) {
            factory.merge(page.validation());
        }
        return factory.create();
    }

    @Override
    public FormComponentPresentation createPresentation(SwtPresentation parent, Composite composite) {
        return new TabGroupPresentation(this, parent, composite);
    }

    @Override
    public void dispose() {
        super.dispose();
        for (SapphirePart sapphirePart : this.pages) {
            sapphirePart.dispose();
        }
    }
}

