/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.ui;

import java.util.Collections;
import java.util.List;
import org.eclipse.sapphire.Element;
import org.eclipse.sapphire.Event;
import org.eclipse.sapphire.services.Service;
import org.eclipse.sapphire.services.ServiceEvent;
import org.eclipse.sapphire.util.CollectionsUtil;
import org.eclipse.sapphire.util.ListFactory;

public final class ListSelectionService
extends Service {
    private List<Element> elements = Collections.emptyList();

    public List<Element> selection() {
        return this.elements;
    }

    public void select(Element element) {
        this.select(ListFactory.start().add((Object)element).result());
    }

    public void select(List<Element> elements) {
        if (!CollectionsUtil.equalsBasedOnEntryIdentity(this.elements, elements)) {
            List<Element> before = this.elements;
            this.elements = ListFactory.unmodifiable(elements);
            this.broadcast((Event)new ListSelectionChangedEvent(this, before, this.elements));
        }
    }

    public static final class ListSelectionChangedEvent
    extends ServiceEvent {
        private List<Element> before;
        private List<Element> after;

        ListSelectionChangedEvent(ListSelectionService service, List<Element> before, List<Element> after) {
            super((Service)service);
            this.before = before;
            this.after = after;
        }

        public List<Element> before() {
            return this.before;
        }

        public List<Element> after() {
            return this.after;
        }
    }
}

