/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.serial;

public enum BaudRate {
    B110(110),
    B300(300),
    B600(600),
    B1200(1200),
    B2400(2400),
    B4800(4800),
    B9600(9600),
    B14400(14400),
    B19200(19200),
    B38400(38400),
    B57600(57600),
    B115200(115200);

    private final int rate;
    private static final String[] strings;
    private static final BaudRate[] rates;

    static {
        strings = new String[]{"110", "300", "600", "1200", "2400", "4800", "9600", "14400", "19200", "38400", "57600", "115200"};
        rates = new BaudRate[]{B110, B300, B600, B1200, B2400, B4800, B9600, B14400, B19200, B38400, B57600, B115200};
    }

    private BaudRate(int rate) {
        this.rate = rate;
    }

    public int getRate() {
        return this.rate;
    }

    public static String[] getStrings() {
        return strings;
    }

    public static BaudRate fromStringIndex(int rate) {
        return rates[rate];
    }

    public static int getStringIndex(BaudRate rate) {
        int i = 0;
        while (i < rates.length) {
            if (rate.equals((Object)rates[i])) {
                return i;
            }
            ++i;
        }
        return BaudRate.getStringIndex(BaudRate.getDefault());
    }

    public static BaudRate getDefault() {
        return B9600;
    }
}

