/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.core.internal.gen;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jpt.common.core.internal.gen.AbstractJptGenerator;
import org.eclipse.jpt.common.utility.internal.StringTools;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorExtensionOptions;
import org.eclipse.jpt.jaxb.core.internal.gen.ClassesGeneratorOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassesGenerator
extends AbstractJptGenerator {
    public static final String LAUNCH_CONFIG_NAME = "JAXB Run Config";
    public static final String JAXB_GENERIC_GEN_CLASS = "com.sun.tools.xjc.XJCFacade";
    public static final String JAXB_GENERIC_GEN_JDK_CLASS = "com.sun.tools.internal.xjc.XJCFacade";
    public static final String JAXB_ECLIPSELINK_GEN_CLASS = "org.eclipse.persistence.jaxb.xjc.MOXyXJC";
    private final String schemaPathOrUri;
    private final String outputDir;
    private final String targetPackage;
    private final String catalog;
    private final String[] bindingsFileNames;
    private final ClassesGeneratorOptions generatorOptions;
    private final ClassesGeneratorExtensionOptions generatorExtensionOptions;
    private final String mainType;
    private String toolsJarPath;

    public static boolean genericJaxbJdkIsOnClasspath(IJavaProject javaProject) {
        try {
            IType genClass = javaProject.findType(JAXB_GENERIC_GEN_JDK_CLASS);
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean genericJaxbNonJdkIsOnClasspath(IJavaProject javaProject) {
        try {
            IType genClass = javaProject.findType(JAXB_GENERIC_GEN_CLASS);
            return genClass != null;
        }
        catch (JavaModelException e) {
            throw new RuntimeException(e);
        }
    }

    public static IVMInstall getVMInstall(IJavaProject javaProject) throws CoreException {
        return JavaRuntime.getVMInstall((IJavaProject)javaProject);
    }

    public static String getVMInstallLocation(IVMInstall vm) {
        return vm.getInstallLocation().getAbsolutePath();
    }

    public static String getVMInstallToolsJarAbsolutePath(IVMInstall vm) {
        String vmInstallLocation = ClassesGenerator.getVMInstallLocation(vm);
        return String.valueOf(vmInstallLocation) + File.separator + "lib" + File.separator + "tools.jar";
    }

    public static String buildToolsJarPath(IJavaProject javaProject) {
        try {
            IVMInstall vm = ClassesGenerator.getVMInstall(javaProject);
            return ClassesGenerator.getVMInstallToolsJarAbsolutePath(vm);
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public static String findToolsJarPath(IJavaProject javaProject) {
        String toolsAbsolutePath = ClassesGenerator.buildToolsJarPath(javaProject);
        return new File(toolsAbsolutePath).exists() ? toolsAbsolutePath : null;
    }

    public static boolean toolsJarExists(IJavaProject javaProject) {
        return ClassesGenerator.findToolsJarPath(javaProject) != null;
    }

    public ClassesGenerator(IJavaProject javaProject, String schemaPathOrUri, String outputDir, String targetPackage, String catalog, boolean usesMoxyGenerator, String[] bindingsFileNames, ClassesGeneratorOptions generatorOptions, ClassesGeneratorExtensionOptions generatorExtensionOptions) {
        super(javaProject);
        this.schemaPathOrUri = schemaPathOrUri;
        this.outputDir = outputDir;
        this.targetPackage = targetPackage;
        this.catalog = catalog;
        this.bindingsFileNames = bindingsFileNames;
        this.generatorOptions = generatorOptions;
        this.generatorExtensionOptions = generatorExtensionOptions;
        this.mainType = this.buildMainType(javaProject, usesMoxyGenerator);
    }

    protected String getMainType() {
        return this.mainType;
    }

    protected String getLaunchConfigName() {
        return LAUNCH_CONFIG_NAME;
    }

    protected void specifyJRE() {
    }

    protected void preGenerate(IProgressMonitor monitor) {
    }

    protected String buildMainType(IJavaProject javaProject, boolean usesMoxyGenerator) {
        if (usesMoxyGenerator) {
            return JAXB_ECLIPSELINK_GEN_CLASS;
        }
        if (ClassesGenerator.genericJaxbNonJdkIsOnClasspath(javaProject)) {
            return JAXB_GENERIC_GEN_CLASS;
        }
        if (ClassesGenerator.genericJaxbJdkIsOnClasspath(javaProject)) {
            return JAXB_GENERIC_GEN_JDK_CLASS;
        }
        this.toolsJarPath = ClassesGenerator.findToolsJarPath(javaProject);
        return JAXB_GENERIC_GEN_JDK_CLASS;
    }

    private IRuntimeClasspathEntry getToolsClasspathEntry() {
        return StringTools.isBlank((String)this.toolsJarPath) ? null : ClassesGenerator.getArchiveClasspathEntry((IPath)new Path(this.toolsJarPath));
    }

    protected List<String> buildClasspath() throws CoreException {
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.add(this.getDefaultProjectClasspathEntry().getMemento());
        classpath.add(this.getSystemLibraryClasspathEntry().getMemento());
        for (IRuntimeClasspathEntry containerClasspathEntry : this.getContainersClasspathEntries()) {
            classpath.add(containerClasspathEntry.getMemento());
        }
        IRuntimeClasspathEntry toolsClasspathEntry = this.getToolsClasspathEntry();
        if (toolsClasspathEntry != null) {
            classpath.add(toolsClasspathEntry.getMemento());
        }
        return classpath;
    }

    protected void specifyProgramArguments() {
        StringBuffer programArguments = new StringBuffer();
        programArguments.append("-d ");
        if (StringTools.isBlank((String)this.outputDir)) {
            throw new RuntimeException("Output directory cannot be empty");
        }
        programArguments.append(StringTools.quote((String)this.outputDir));
        if (!StringTools.isBlank((String)this.targetPackage)) {
            programArguments.append(" -p ");
            programArguments.append(this.targetPackage);
        }
        if (!StringTools.isBlank((String)this.catalog)) {
            programArguments.append(" -catalog ");
            programArguments.append(StringTools.quote((String)this.catalog));
        }
        if (!StringTools.isBlank((String)this.generatorOptions.getProxy())) {
            programArguments.append(" -httpproxy ");
            programArguments.append(this.generatorOptions.getProxy());
        }
        if (!StringTools.isBlank((String)this.generatorOptions.getProxyFile())) {
            programArguments.append(" -httpproxyfile ");
            programArguments.append(StringTools.quote((String)this.generatorOptions.getProxyFile()));
        }
        if (!this.generatorOptions.usesStrictValidation()) {
            programArguments.append(" -nv");
        }
        if (this.generatorOptions.makesReadOnly()) {
            programArguments.append(" -readOnly");
        }
        if (this.generatorOptions.suppressesPackageInfoGen()) {
            programArguments.append(" -npa");
        }
        if (this.generatorOptions.suppressesHeaderGen()) {
            programArguments.append(" -no-header");
        }
        if (this.generatorOptions.isVerbose()) {
            programArguments.append(" -verbose");
        }
        if (this.generatorOptions.isQuiet()) {
            programArguments.append(" -quiet");
        }
        if (this.generatorOptions.treatsAsXmlSchema()) {
            programArguments.append(" -xmlschema");
        }
        if (this.generatorOptions.treatsAsRelaxNg()) {
            programArguments.append(" -relaxng");
        }
        if (this.generatorOptions.treatsAsRelaxNgCompact()) {
            programArguments.append(" -relaxng-compact");
        }
        if (this.generatorOptions.treatsAsDtd()) {
            programArguments.append(" -dtd");
        }
        if (this.generatorOptions.treatsAsWsdl()) {
            programArguments.append(" -wsdl");
        }
        if (this.generatorOptions.showsVersion()) {
            programArguments.append(" -version");
        }
        if (this.generatorOptions.showsHelp()) {
            programArguments.append(" -help");
        }
        if (this.generatorExtensionOptions.allowsExtensions()) {
            programArguments.append(" -extension");
        }
        if (!StringTools.isBlank((String)this.generatorExtensionOptions.getClasspath())) {
            programArguments.append(" -classpath ");
            programArguments.append(StringTools.quote((String)this.generatorExtensionOptions.getClasspath()));
        }
        if (!StringTools.isBlank((String)this.generatorExtensionOptions.getAdditionalArgs())) {
            programArguments.append(' ');
            programArguments.append(this.generatorExtensionOptions.getAdditionalArgs());
        }
        programArguments.append(' ');
        if (StringTools.isBlank((String)this.schemaPathOrUri)) {
            throw new RuntimeException("Schema cannot be empty");
        }
        programArguments.append(StringTools.quote((String)this.schemaPathOrUri));
        if (this.bindingsFileNames.length > 0) {
            String[] stringArray = this.bindingsFileNames;
            int n = this.bindingsFileNames.length;
            int n2 = 0;
            while (n2 < n) {
                String bindingsFileName = stringArray[n2];
                programArguments.append(" -b ");
                programArguments.append(StringTools.quote((String)bindingsFileName));
                ++n2;
            }
        }
        this.getLaunchConfig().setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, programArguments.toString());
    }

    private List<IRuntimeClasspathEntry> getContainersClasspathEntries() throws CoreException {
        ArrayList<IRuntimeClasspathEntry> classpathEntries = new ArrayList<IRuntimeClasspathEntry>();
        IClasspathEntry[] iClasspathEntryArray = this.getJavaProject().getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathContainer container;
            IClasspathEntry classpathEntry = iClasspathEntryArray[n2];
            if (classpathEntry.getEntryKind() == 5 && (container = JavaCore.getClasspathContainer((IPath)classpathEntry.getPath(), (IJavaProject)this.getJavaProject())) != null && container.getKind() == 2) {
                classpathEntries.add(JavaRuntime.newRuntimeContainerClasspathEntry((IPath)container.getPath(), (int)2, (IJavaProject)this.getJavaProject()));
            }
            ++n2;
        }
        return classpathEntries;
    }
}

