/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.wizards.datatransfer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.internal.wizards.datatransfer.Activator;
import org.eclipse.ui.internal.wizards.datatransfer.EclipseProjectConfigurator;
import org.eclipse.ui.internal.wizards.datatransfer.expressions.FileExpressionHandler;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class ProjectConfiguratorExtensionManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.e4.ui.importer.projectConfigurators";
    private IConfigurationElement[] extensions;
    private ExpressionConverter expressionConverter;
    private Map<IConfigurationElement, ProjectConfigurator> configuratorsByExtension = new HashMap<IConfigurationElement, ProjectConfigurator>();

    public ProjectConfiguratorExtensionManager() {
        this.extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int eclipseConfiguratorIndex = 0;
        while (eclipseConfiguratorIndex < this.extensions.length && !this.extensions[eclipseConfiguratorIndex].getAttribute("class").equals(EclipseProjectConfigurator.class.getName())) {
            ++eclipseConfiguratorIndex;
        }
        if (eclipseConfiguratorIndex != 0 && eclipseConfiguratorIndex < this.extensions.length) {
            IConfigurationElement tmp = this.extensions[eclipseConfiguratorIndex];
            this.extensions[eclipseConfiguratorIndex] = this.extensions[0];
            this.extensions[0] = tmp;
        }
        this.expressionConverter = new ExpressionConverter(new ElementHandler[]{ElementHandler.getDefault(), new FileExpressionHandler()});
    }

    public Collection<ProjectConfigurator> getAllActiveProjectConfigurators(IContainer container) {
        HashSet<ProjectConfigurator> res = new HashSet<ProjectConfigurator>();
        IConfigurationElement[] iConfigurationElementArray = this.extensions;
        int n = this.extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            IConfigurationElement[] activeWhenElements = extension.getChildren("activeWhen");
            if (activeWhenElements.length == 0) {
                res.add(this.getConfigurator(extension));
            } else if (activeWhenElements.length == 1) {
                IConfigurationElement activeWhen = activeWhenElements[0];
                IConfigurationElement[] activeWhenChildren = activeWhen.getChildren();
                if (activeWhenChildren.length == 1) {
                    try {
                        Expression expression = this.expressionConverter.perform(activeWhen.getChildren()[0]);
                        EvaluationContext context = new EvaluationContext(null, (Object)container);
                        if (expression.evaluate((IEvaluationContext)context).equals(EvaluationResult.TRUE)) {
                            res.add(this.getConfigurator(extension));
                        }
                    }
                    catch (CoreException ex) {
                        Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.ui.importer", "Could not evaluate expression for " + extension.getContributor().getName(), (Throwable)ex));
                    }
                } else {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.ui.importer", "Could not evaluate xpression for " + extension.getContributor().getName() + ": there must be exactly one child of 'activeWhen'"));
                }
            } else {
                throw new IllegalArgumentException("Only one 'activeWhen' is authorized on extension point org.eclipse.e4.ui.importer.projectConfigurators, for extension contributed by " + extension.getContributor().getName());
            }
            ++n2;
        }
        return res;
    }

    private ProjectConfigurator getConfigurator(IConfigurationElement extension) {
        if (!this.configuratorsByExtension.containsKey(extension)) {
            try {
                ProjectConfigurator configurator = (ProjectConfigurator)extension.createExecutableExtension("class");
                this.configuratorsByExtension.put(extension, configurator);
                return configurator;
            }
            catch (CoreException ex) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.e4.ui.importer", ex.getMessage(), (Throwable)ex));
                return null;
            }
        }
        return this.configuratorsByExtension.get(extension);
    }

    public static List<String> getAllExtensionLabels() {
        IConfigurationElement[] extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        ArrayList<String> res = new ArrayList<String>(extensions.length);
        IConfigurationElement[] iConfigurationElementArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            res.add(extension.getAttribute("label"));
            ++n2;
        }
        return res;
    }

    public static Object getLabel(ProjectConfigurator configurator) {
        IConfigurationElement[] extensions;
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement extension = iConfigurationElementArray[n2];
            if (configurator.getClass().getName().equals(extension.getAttribute("class"))) {
                return extension.getAttribute("label");
            }
            ++n2;
        }
        return "Missing label for " + configurator.getClass().getName();
    }
}

