/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.swing;

import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicComboBoxUI;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.swing.CachingComboBoxModel;
import org.eclipse.jpt.common.utility.internal.swing.EmptyIcon;
import org.eclipse.jpt.common.utility.internal.swing.NonCachingComboBoxModel;
import org.eclipse.jpt.common.utility.internal.swing.SimpleListBrowser;

public class ListChooser
extends JComboBox {
    int longListSize = 20;
    public static final int DEFAULT_LONG_LIST_SIZE = 20;
    public static final String LONG_LIST_SIZE_PROPERTY = "longListSize";
    static JLabel prototypeLabel = new JLabel("Prototype", new EmptyIcon(17), 10);
    boolean choosable = true;
    public static final String CHOOSABLE_PROPERTY = "choosable";
    private ListBrowser browser;
    private NodeSelector nodeSelector;
    boolean popupAlreadyInProgress;
    private static final long serialVersionUID = 1L;

    public ListChooser(ComboBoxModel model) {
        this(model, NodeSelector.Default.instance());
    }

    public ListChooser(CachingComboBoxModel model) {
        this(model, NodeSelector.Default.instance());
    }

    public ListChooser(ComboBoxModel model, NodeSelector nodeSelector) {
        this(new NonCachingComboBoxModel(model), nodeSelector);
    }

    public ListChooser(CachingComboBoxModel model, NodeSelector nodeSelector) {
        super(model);
        this.initialize();
        this.nodeSelector = nodeSelector;
    }

    protected void initialize() {
        this.addPopupMenuListener(this.buildPopupMenuListener());
        this.setRenderer((ListCellRenderer)new DefaultListCellRenderer());
        this.addKeyListener(this.buildF3KeyListener());
        this.setPrototypeDisplayValue(prototypeLabel);
        this.listBox().setPrototypeCellValue(prototypeLabel);
    }

    private JList listBox() {
        return (JList)ObjectTools.get(this.ui, "listBox");
    }

    private PopupMenuListener buildPopupMenuListener() {
        return new PopupMenuListener(){

            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ListChooser.this.aboutToShowPopup();
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            public void popupMenuCanceled(PopupMenuEvent e) {
            }

            public String toString() {
                return "pop-up menu listener";
            }
        };
    }

    void aboutToShowPopup() {
        if (this.popupAlreadyInProgress) {
            return;
        }
        this.popupAlreadyInProgress = true;
        EventQueue.invokeLater(new PopupHandler());
    }

    private KeyListener buildF3KeyListener() {
        return new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 114) {
                    ListChooser.this.goToSelectedItem();
                }
            }

            public String toString() {
                return "F3 key listener";
            }
        };
    }

    public void goToSelectedItem() {
        if (this.getSelectedItem() != null) {
            this.nodeSelector.selectNodeFor(this.getSelectedItem());
        }
    }

    protected void browse() {
        if (this.browser == null) {
            this.browser = this.buildBrowser();
        }
        this.browser.browse(this);
    }

    protected ListBrowser buildBrowser() {
        return new SimpleListBrowser();
    }

    public void setSelectedIndex(int anIndex) {
        if (this.choosable) {
            super.setSelectedIndex(anIndex);
        }
    }

    private void updateArrowButton() {
        try {
            BasicComboBoxUI comboBoxUi = (BasicComboBoxUI)this.getUI();
            JButton arrowButton = (JButton)ObjectTools.get(comboBoxUi, "arrowButton");
            arrowButton.setEnabled(this.isEnabled() && this.choosable);
        }
        catch (Exception exception) {}
    }

    void cacheList() {
        ((CachingComboBoxModel)this.getModel()).cacheList();
    }

    void uncacheList() {
        ((CachingComboBoxModel)this.getModel()).uncacheList();
    }

    boolean listIsCached() {
        return ((CachingComboBoxModel)this.getModel()).isCached();
    }

    public int longListSize() {
        return this.longListSize;
    }

    public void setLongListSize(int newLongListSize) {
        int oldLongListSize = this.longListSize;
        this.longListSize = newLongListSize;
        this.firePropertyChange(LONG_LIST_SIZE_PROPERTY, oldLongListSize, newLongListSize);
    }

    public boolean isChoosable() {
        return this.choosable;
    }

    public void setChoosable(boolean newValue) {
        boolean oldValue = this.choosable;
        this.choosable = newValue;
        this.firePropertyChange(CHOOSABLE_PROPERTY, oldValue, newValue);
        this.updateArrowButton();
    }

    private boolean selectedIndexIsNoneSelectedItem(int index) {
        return index == -1 && this.getModel().getSize() > 0 && this.getModel().getElementAt(0) == null;
    }

    public int getSelectedIndex() {
        int index;
        boolean listNotCached;
        boolean bl = listNotCached = !this.listIsCached();
        if (listNotCached) {
            this.cacheList();
        }
        if (this.selectedIndexIsNoneSelectedItem(index = super.getSelectedIndex())) {
            index = 0;
        }
        if (listNotCached) {
            this.uncacheList();
        }
        return index;
    }

    public void setRenderer(final ListCellRenderer aRenderer) {
        super.setRenderer(new ListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value == prototypeLabel) {
                    return prototypeLabel;
                }
                return aRenderer.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
    }

    public static interface ListBrowser {
        public void browse(ListChooser var1);
    }

    public static interface NodeSelector {
        public void selectNodeFor(Object var1);

        public static final class Default
        implements NodeSelector,
        Serializable {
            public static final NodeSelector INSTANCE = new Default();
            private static final long serialVersionUID = 1L;

            public static NodeSelector instance() {
                return INSTANCE;
            }

            private Default() {
            }

            public void selectNodeFor(Object item) {
            }

            public String toString() {
                return ObjectTools.singletonToString(this);
            }

            private Object readResolve() {
                return INSTANCE;
            }
        }
    }

    private class PopupHandler
    implements Runnable {
        private MouseEvent lastMouseEvent;
        private JComponent eventComponent;
        private Point componentLocation;
        private Point mouseLocation;

        PopupHandler() {
            this.initialize();
        }

        private void initialize() {
            AWTEvent event = EventQueue.getCurrentEvent();
            if (event instanceof MouseEvent) {
                this.lastMouseEvent = (MouseEvent)event;
                this.eventComponent = (JComponent)this.lastMouseEvent.getSource();
                this.componentLocation = this.eventComponent.getLocationOnScreen();
                this.mouseLocation = this.lastMouseEvent.getPoint();
            } else {
                this.eventComponent = null;
                this.componentLocation = null;
                this.mouseLocation = null;
            }
        }

        public void run() {
            ListChooser.this.hidePopup();
            ListChooser.this.cacheList();
            if (ListChooser.this.choosable) {
                if (ListChooser.this.getModel().getSize() > ListChooser.this.longListSize) {
                    this.checkComboBoxButton();
                    ListChooser.this.browse();
                } else {
                    ListChooser.this.showPopup();
                    this.checkMousePosition();
                }
            }
            if (ListChooser.this.listIsCached()) {
                ListChooser.this.uncacheList();
            }
            ListChooser.this.popupAlreadyInProgress = false;
        }

        private void checkComboBoxButton() {
            try {
                BasicComboBoxUI comboBoxUi = (BasicComboBoxUI)ListChooser.this.getUI();
                JButton arrowButton = (JButton)ObjectTools.get(comboBoxUi, "arrowButton");
                arrowButton.getModel().setPressed(false);
            }
            catch (Exception ex) {
                this.handleException(ex);
            }
        }

        private void handleException(Exception ex) {
        }

        private void checkMousePosition() {
            boolean componentMoved;
            if (this.eventComponent == null) {
                return;
            }
            Point newComponentLocation = this.eventComponent.getLocationOnScreen();
            boolean bl = componentMoved = newComponentLocation.x - this.componentLocation.x != 0 || newComponentLocation.y - this.componentLocation.y != 0;
            if (componentMoved) {
                try {
                    new Robot().mouseMove(newComponentLocation.x + this.mouseLocation.x, newComponentLocation.y + this.mouseLocation.y);
                }
                catch (AWTException aWTException) {}
            }
        }
    }
}

