/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.jdbc;

import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetIterator;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetRowTransformer;
import org.eclipse.jpt.common.utility.internal.jdbc.ResultSetRowTransformerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultSetTools {
    public static final ResultSetRowTransformer DEFAULT_ROW_TRANSFORMER = new DefaultRowTransformer();

    public static <E> ResultSetIterator<E> iterator(ResultSet resultSet) throws SQLException {
        return ResultSetTools.iterator(resultSet, ResultSetTools.<E>defaultRowTransformer());
    }

    public static <E> ResultSetRowTransformer<E> defaultRowTransformer() {
        return DEFAULT_ROW_TRANSFORMER;
    }

    public static <E> ResultSetIterator<E> iterator(ResultSet resultSet, ResultSetRowTransformer<? extends E> rowTransformer) throws SQLException {
        return new ResultSetIterator<E>(resultSet, rowTransformer);
    }

    public static List<Map<String, Object>> convertToMaps(ResultSet resultSet) throws SQLException {
        return ResultSetTools.convertToList(resultSet, ResultSetTools.mapRowTransformer(resultSet));
    }

    public static <E> List<E> convertToList(ResultSet resultSet, ResultSetRowTransformer<? extends E> rowTransformer) throws SQLException {
        ArrayList<E> rows = new ArrayList<E>();
        ResultSetIterator<E> stream = ResultSetTools.iterator(resultSet, rowTransformer);
        while (stream.hasNext()) {
            rows.add(stream.next());
        }
        return rows;
    }

    public static ResultSetIterator<Map<String, Object>> mapIterator(ResultSet resultSet) throws SQLException {
        return ResultSetTools.iterator(resultSet, ResultSetTools.mapRowTransformer(resultSet));
    }

    public static MapRowTransformer mapRowTransformer(ResultSet resultSet) throws SQLException {
        return new MapRowTransformer(resultSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(ResultSet resultSet) throws SQLException {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
        PrintStream printStream = System.out;
        synchronized (printStream) {
            ResultSetTools.dumpOn(resultSet, pw);
        }
        pw.flush();
    }

    public static void dumpOn(ResultSet resultSet, PrintWriter pw) throws SQLException {
        List<Map<String, Object>> maps = ResultSetTools.convertToMaps(resultSet);
        Iterator<Map<String, Object>> mapStream = maps.iterator();
        while (mapStream.hasNext()) {
            for (Map.Entry<String, Object> entry : mapStream.next().entrySet()) {
                pw.print(entry.getKey());
                pw.print(" = ");
                pw.print(entry.getValue());
                pw.println();
            }
            if (!mapStream.hasNext()) continue;
            pw.println();
        }
        pw.println("total rows: " + maps.size());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultRowTransformer<E>
    extends ResultSetRowTransformerAdapter<E> {
        @Override
        public E transform(ResultSet rs) throws SQLException {
            return (E)rs.getObject(1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapRowTransformer
    extends ResultSetRowTransformerAdapter<Map<String, Object>> {
        private final int columnCount;
        private final String[] columnNames;

        public MapRowTransformer(ResultSet resultSet) throws SQLException {
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            this.columnCount = rsMetaData.getColumnCount() + 1;
            this.columnNames = this.buildColumnNames(rsMetaData);
        }

        private String[] buildColumnNames(ResultSetMetaData rsMetaData) throws SQLException {
            String[] names = new String[this.columnCount];
            int i = 1;
            while (i < names.length) {
                names[i] = rsMetaData.getColumnName(i);
                ++i;
            }
            return names;
        }

        @Override
        public Map<String, Object> transform(ResultSet resultSet) throws SQLException {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(this.columnCount);
            int i = 1;
            while (i < this.columnCount) {
                map.put(this.columnNames[i], resultSet.getObject(i));
                ++i;
            }
            return map;
        }
    }
}

