/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.actions;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.embedder.ArtifactKey;
import org.eclipse.m2e.core.embedder.ArtifactRef;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MavenActionSupport
implements IObjectActionDelegate {
    private static final Logger log = LoggerFactory.getLogger(MavenActionSupport.class);
    protected IStructuredSelection selection;
    protected IWorkbenchPart targetPart;

    protected Set<ArtifactKey> getArtifacts(IFile file, MavenPlugin plugin) {
        try {
            IMavenProjectFacade projectFacade = MavenPlugin.getMavenProjectRegistry().create(file, true, (IProgressMonitor)new NullProgressMonitor());
            if (projectFacade != null) {
                return ArtifactRef.toArtifactKey((Set)projectFacade.getMavenProjectArtifacts());
            }
        }
        catch (Exception ex) {
            log.error("Can't read Maven project: " + ex.getMessage(), (Throwable)ex);
        }
        return Collections.emptySet();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    protected Shell getShell() {
        Shell shell = null;
        if (this.targetPart != null) {
            shell = this.targetPart.getSite().getShell();
        }
        if (shell != null) {
            return shell;
        }
        IWorkbench workbench = M2EUIPluginActivator.getDefault().getWorkbench();
        if (workbench == null) {
            return null;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        return window == null ? null : window.getShell();
    }

    protected IFile getPomFileFromPomEditorOrViewSelection() {
        return SelectionUtil.getPomFileFromPomEditorOrViewSelection((ISelection)this.selection);
    }
}

