/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.source;

import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jpt.common.core.internal.resource.java.source.SourceMember;
import org.eclipse.jpt.common.core.internal.utility.jdt.JavaResourceTypeBinding;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAbstractType;
import org.eclipse.jpt.common.core.resource.java.JavaResourceCompilationUnit;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AbstractType;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;
import org.eclipse.jpt.common.utility.internal.ObjectTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class SourceAbstractType<A extends AbstractType>
extends SourceMember<A>
implements JavaResourceAbstractType {
    private JavaResourceTypeBinding typeBinding;
    private String declaringTypeName;

    protected SourceAbstractType(JavaResourceCompilationUnit javaResourceCompilationUnit, A type) {
        super((JavaResourceModel)javaResourceCompilationUnit, type);
    }

    protected void initialize(ITypeBinding binding) {
        super.initialize((IBinding)binding);
        this.typeBinding = this.buildTypeBinding(binding);
        this.declaringTypeName = this.buildDeclaringTypeName(binding);
    }

    protected void initialize(AbstractTypeDeclaration typeDeclaration) {
        super.initialize((ASTNode)typeDeclaration, (Name)typeDeclaration.getName());
        this.initialize(typeDeclaration.resolveBinding());
    }

    protected void synchronizeWith(ITypeBinding binding) {
        super.synchronizeWith((IBinding)binding);
        this.syncTypeBinding(binding);
        this.syncDeclaringTypeName(this.buildDeclaringTypeName(binding));
    }

    public void synchronizeWith(AbstractTypeDeclaration typeDeclaration) {
        super.synchronizeWith((ASTNode)typeDeclaration, (Name)typeDeclaration.getName());
        this.synchronizeWith(typeDeclaration.resolveBinding());
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    @Override
    public String getName() {
        return this.typeBinding.getSimpleName();
    }

    @Override
    public TypeBinding getTypeBinding() {
        return this.typeBinding;
    }

    private JavaResourceTypeBinding buildTypeBinding(ITypeBinding jdtTypeBinding) {
        return new JavaResourceTypeBinding(jdtTypeBinding);
    }

    private void syncTypeBinding(ITypeBinding jdtTypeBinding) {
        if (this.typeBinding.isEquivalentTo(jdtTypeBinding)) {
            return;
        }
        JavaResourceTypeBinding old = this.typeBinding;
        this.typeBinding = this.buildTypeBinding(jdtTypeBinding);
        this.firePropertyChanged("typeBinding", old, this.typeBinding);
    }

    @Override
    public boolean isIn(IPackageFragment packageFragment) {
        return ObjectTools.equals((Object)packageFragment.getElementName(), (Object)this.typeBinding.getPackageName());
    }

    @Override
    public boolean isIn(IPackageFragmentRoot sourceFolder) {
        return this.getSourceFolder().equals(sourceFolder);
    }

    private IPackageFragmentRoot getSourceFolder() {
        return (IPackageFragmentRoot)this.getJavaResourceCompilationUnit().getCompilationUnit().getAncestor(3);
    }

    @Override
    public String getDeclaringTypeName() {
        return this.declaringTypeName;
    }

    private void syncDeclaringTypeName(String astDeclaringTypeName) {
        String old = this.declaringTypeName;
        this.declaringTypeName = astDeclaringTypeName;
        this.firePropertyChanged("declaringTypeName", old, astDeclaringTypeName);
    }

    private String buildDeclaringTypeName(ITypeBinding binding) {
        if (binding == null) {
            return null;
        }
        ITypeBinding declaringClass = binding.getDeclaringClass();
        return declaringClass == null ? null : declaringClass.getTypeDeclaration().getQualifiedName();
    }
}

