/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource.java.binary;

import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.java.binary.BinaryMember;
import org.eclipse.jpt.common.core.internal.utility.jdt.JavaResourceTypeBinding;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAttribute;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.resource.java.JavaResourceType;
import org.eclipse.jpt.common.core.utility.jdt.TypeBinding;

abstract class BinaryAttribute
extends BinaryMember
implements JavaResourceAttribute {
    private String attributeName;
    private int modifiers;
    private TypeBinding typeBinding;

    protected BinaryAttribute(JavaResourceType parent, AttributeAdapter adapter) {
        super((JavaResourceModel)parent, adapter);
        this.attributeName = adapter.getAttributeName();
        this.modifiers = this.buildModifiers();
        this.typeBinding = this.buildTypeBinding(adapter.getTypeBinding());
    }

    public void update() {
        super.update();
        this.updateAttributeName();
        this.updateModifiers();
        this.updateTypeBinding();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getName());
    }

    public JavaResourceType getParent() {
        return (JavaResourceType)super.getParent();
    }

    public JavaResourceType getResourceType() {
        return this.getParent();
    }

    public String getName() {
        return this.getAttributeName();
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    protected void updateAttributeName() {
        throw new UnsupportedOperationException();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    private int buildModifiers() {
        try {
            return this.getElement().getFlags();
        }
        catch (JavaModelException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return 0;
        }
    }

    protected void updateModifiers() {
        throw new UnsupportedOperationException();
    }

    public TypeBinding getTypeBinding() {
        return this.typeBinding;
    }

    protected TypeBinding buildTypeBinding(ITypeBinding jdtTypeBinding) {
        return new JavaResourceTypeBinding(jdtTypeBinding);
    }

    protected void updateTypeBinding() {
        throw new UnsupportedOperationException();
    }

    static interface AttributeAdapter
    extends BinaryMember.MemberAdapter {
        public String getAttributeName();

        public ITypeBinding getTypeBinding();
    }
}

