/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.core.internal.resource;

import java.util.Comparator;
import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jpt.common.core.internal.plugin.JptCommonCorePlugin;
import org.eclipse.jpt.common.core.internal.resource.InternalResourceLocatorManager;
import org.eclipse.jpt.common.core.internal.utility.ExtensionPointTools;
import org.eclipse.jpt.common.core.resource.ResourceLocator;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.predicate.CriterionPredicate;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerAdapter;
import org.eclipse.jpt.common.utility.transformer.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResourceLocatorConfig
implements Comparable<ResourceLocatorConfig> {
    private final InternalResourceLocatorManager manager;
    private final String id;
    private final String className;
    private final Priority priority;
    private String pluginID;
    private Expression enablementExpression;
    private ResourceLocator resourceLocator;
    private static final String PROJECT_ENABLEMENT_EXPRESSION_VARIABLE = "project";
    static final Transformer<ResourceLocatorConfig, ResourceLocator> RESOURCE_LOCATOR_TRANSFORMER = new ResourceLocatorTransformer();

    ResourceLocatorConfig(InternalResourceLocatorManager manager, String id, String className, Priority priority) {
        this.manager = manager;
        this.id = id;
        this.className = className;
        this.priority = priority;
    }

    InternalResourceLocatorManager getManager() {
        return this.manager;
    }

    String getID() {
        return this.id;
    }

    String getClassName() {
        return this.className;
    }

    Priority getPriority() {
        return this.priority;
    }

    String getPluginID() {
        return this.pluginID;
    }

    void setPluginID(String pluginID) {
        this.pluginID = pluginID;
    }

    Expression getEnablementExpression() {
        return this.enablementExpression;
    }

    void setEnablementExpression(Expression enablementExpression) {
        this.enablementExpression = enablementExpression;
    }

    boolean isEnabled(IProject project) {
        return this.enablementExpression == null || this.isEnabled_(project);
    }

    boolean isEnabled_(IProject project) {
        EvaluationContext evalContext = new EvaluationContext(null, (Object)project);
        evalContext.setAllowPluginActivation(true);
        evalContext.addVariable(PROJECT_ENABLEMENT_EXPRESSION_VARIABLE, (Object)project);
        try {
            return this.enablementExpression.evaluate((IEvaluationContext)evalContext) == EvaluationResult.TRUE;
        }
        catch (CoreException ex) {
            JptCommonCorePlugin.instance().logError(ex);
            return false;
        }
    }

    synchronized ResourceLocator getResourceLocator() {
        if (this.resourceLocator == null) {
            this.resourceLocator = this.buildResourceLocator();
        }
        return this.resourceLocator;
    }

    private ResourceLocator buildResourceLocator() {
        return ExtensionPointTools.instantiate(this.pluginID, this.manager.getExtensionPointName(), this.className, ResourceLocator.class);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, (CharSequence)this.className);
    }

    @Override
    public int compareTo(ResourceLocatorConfig other) {
        return Priority.DefaultComparator.instance().compare(this.priority, other.priority);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class IsEnabled
    extends CriterionPredicate<ResourceLocatorConfig, IProject> {
        IsEnabled(IProject project) {
            super((Object)project);
        }

        public boolean evaluate(ResourceLocatorConfig config) {
            return config.isEnabled((IProject)this.criterion);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Priority {
        HIGHEST(0, "highest"),
        HIGHER(1, "higher"),
        HIGH(2, "high"),
        NORMAL(3, "normal"),
        LOW(4, "low"),
        LOWER(5, "lower"),
        LOWEST(6, "lowest");

        int value;
        private String literal;

        static Priority get(String literal) {
            if (literal == null) {
                return NORMAL;
            }
            Priority[] priorityArray = Priority.values();
            int n = priorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                Priority priority = priorityArray[n2];
                if (literal.equals(priority.literal)) {
                    return priority;
                }
                ++n2;
            }
            return null;
        }

        private Priority(int value, String literal) {
            this.value = value;
            this.literal = literal;
        }

        public String toString() {
            return this.literal;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static class DefaultComparator
        implements Comparator<Priority> {
            private static final Comparator<Priority> INSTANCE = new DefaultComparator();

            static Comparator<Priority> instance() {
                return INSTANCE;
            }

            private DefaultComparator() {
            }

            @Override
            public int compare(Priority priority1, Priority priority2) {
                int value1 = priority1.value;
                int value2 = priority2.value;
                return value1 < value2 ? -1 : (value1 == value2 ? 0 : 1);
            }

            public String toString() {
                return ObjectTools.singletonToString((Object)this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResourceLocatorTransformer
    extends TransformerAdapter<ResourceLocatorConfig, ResourceLocator> {
        ResourceLocatorTransformer() {
        }

        public ResourceLocator transform(ResourceLocatorConfig config) {
            return config.getResourceLocator();
        }
    }
}

