/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.jsfappconfig;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.jsfappconfig.AbstractJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.jsfappconfig.AnnotationPackageFragmentRoot;
import org.eclipse.jst.jsf.core.jsfappconfig.AnnotationSearchRequestor;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigFactory;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationJSFAppConfigProvider
extends AbstractJSFAppConfigProvider {
    static final String MANAGED_BEAN_ANNOTATION_CLASS = "javax.faces.bean.ManagedBean";
    static final String REFERENCED_BEAN_ANNOTATION_CLASS = "javax.faces.bean.ReferencedBean";
    static final String FACES_COMPONENT_ANNOTATION_CLASS = "javax.faces.component.FacesComponent";
    static final String FACES_CONVERTER_ANNOTATION_CLASS = "javax.faces.convert.FacesConverter";
    static final String FACES_RENDERER_ANNOTATION_CLASS = "javax.faces.render.FacesRenderer";
    static final String FACES_VALIDATOR_ANNOTATION_CLASS = "javax.faces.validator.FacesValidator";
    static final String NONE_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.NoneScoped";
    static final String VIEW_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.ViewScoped";
    static final String SESSION_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.SessionScoped";
    static final String APPLICATION_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.ApplicationScoped";
    static final String CUSTOM_SCOPED_ANNOTATION_CLASS = "javax.faces.bean.CustomScoped";
    static final String CDI_NAMED_BEAN_ANNOTATION_CLASS = "javax.inject.Named";
    static final String CDI_MODEL_BEAN_ANNOTATION_CLASS = "javax.enterprise.inject.Model";
    static final String CDI_REQUEST_SCOPED_ANNOTATION_CLASS = "javax.enterprise.context.RequestScoped";
    static final String CDI_CONVERSATION_SCOPED_ANNOTATION_CLASS = "javax.enterprise.context.ConversationScoped";
    static final String CDI_SESSION_SCOPED_ANNOTATION_CLASS = "javax.enterprise.context.SessionScoped";
    static final String CDI_APPLICATION_SCOPED_ANNOTATION_CLASS = "javax.enterprise.context.ApplicationScoped";
    private FacesConfigType facesConfig = null;

    @Override
    public synchronized FacesConfigType getFacesConfigModel() {
        if (this.facesConfig == null) {
            try {
                this.discoverFacesConfig();
            }
            catch (CoreException ce) {
                JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
                this.facesConfig = null;
            }
            if (this.facesConfig != null) {
                this.jsfAppConfigLocater.getJSFAppConfigManager().addFacesConfigChangeAdapter(this.facesConfig);
            }
        }
        return this.facesConfig;
    }

    @Override
    public void releaseFacesConfigModel() {
        this.jsfAppConfigLocater.getJSFAppConfigManager().removeFacesConfigChangeAdapter(this.facesConfig);
        this.facesConfig = null;
    }

    private void discoverFacesConfig() throws CoreException {
        this.facesConfig = FacesConfigFactory.eINSTANCE.createFacesConfigType();
        IJavaProject jProject = JavaCore.create((IProject)this.jsfAppConfigLocater.getJSFAppConfigManager().getProject());
        IPackageFragmentRoot[] roots = jProject.getAllPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> scannableRoots = new ArrayList<IPackageFragmentRoot>();
        if (roots != null) {
            IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
            int n = roots.length;
            int n2 = 0;
            while (n2 < n) {
                IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                AnnotationPackageFragmentRoot facesRoot = new AnnotationPackageFragmentRoot(root);
                if (facesRoot.canContainAnnotatedComponents()) {
                    scannableRoots.add(root);
                }
                ++n2;
            }
        }
        if (!scannableRoots.isEmpty()) {
            this.findAnnotatedComponents(jProject, scannableRoots);
        }
    }

    private final void findAnnotatedComponents(IJavaProject jProject, List<IPackageFragmentRoot> scannableRoots) throws CoreException {
        SearchPattern pattern = this.orPattern(null, (IJavaElement)jProject.findType(MANAGED_BEAN_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(REFERENCED_BEAN_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(FACES_COMPONENT_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(FACES_CONVERTER_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(FACES_RENDERER_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(FACES_VALIDATOR_ANNOTATION_CLASS));
        pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(CDI_NAMED_BEAN_ANNOTATION_CLASS));
        if ((pattern = this.orPattern(pattern, (IJavaElement)jProject.findType(CDI_MODEL_BEAN_ANNOTATION_CLASS))) != null) {
            SearchEngine engine = new SearchEngine();
            SearchParticipant[] participants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])scannableRoots.toArray(new IJavaElement[scannableRoots.size()]), (int)3);
            AnnotationSearchRequestor requestor = new AnnotationSearchRequestor(this.facesConfig);
            engine.search(pattern, participants, scope, (SearchRequestor)requestor, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    private SearchPattern orPattern(SearchPattern pattern, IJavaElement element) {
        if (element == null) {
            return pattern;
        }
        if (pattern == null) {
            return SearchPattern.createPattern((IJavaElement)element, (int)2);
        }
        return SearchPattern.createOrPattern((SearchPattern)pattern, (SearchPattern)SearchPattern.createPattern((IJavaElement)element, (int)2));
    }
}

