/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.preferences.ConfigurationEditorComponent;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class RepositoryPropertySource
implements IPropertySource {
    static final String CHANGEMODEACTIONID = "ChangeMode";
    static final String SINGLEVALUEACTIONID = "SingleValueToggle";
    static final String EDITACTIONID = "Edit";
    private static final String SYSTEM_ID_PREFIX = "system";
    private static final String USER_ID_PREFIX = "user";
    private static final String REPO_ID_PREFIX = "repo";
    private static final String EFFECTIVE_ID_PREFIX = "effe";
    private final PropertySheetPage myPage;
    private final FileBasedConfig systemConfig;
    private final FileBasedConfig userHomeConfig;
    private final StoredConfig repositoryConfig;
    private final StoredConfig effectiveConfig;
    private ActionContributionItem changeModeAction;
    private ActionContributionItem editAction;
    private ActionContributionItem singleValueToggleAction;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryPropertySource(Repository repository, PropertySheetPage page) {
        this.myPage = page;
        this.effectiveConfig = repository.getConfig();
        this.systemConfig = SystemReader.getInstance().openSystemConfig(null, FS.DETECTED);
        this.userHomeConfig = SystemReader.getInstance().openUserConfig(null, FS.DETECTED);
        if (this.effectiveConfig instanceof FileBasedConfig) {
            File configFile = ((FileBasedConfig)this.effectiveConfig).getFile();
            this.repositoryConfig = new FileBasedConfig(configFile, repository.getFS());
        } else {
            this.repositoryConfig = this.effectiveConfig;
        }
        PropertySheetPage propertySheetPage = this.myPage;
        synchronized (propertySheetPage) {
            IActionBars bars = this.myPage.getSite().getActionBars();
            this.changeModeAction = (ActionContributionItem)bars.getToolBarManager().find(CHANGEMODEACTIONID);
            this.singleValueToggleAction = (ActionContributionItem)bars.getToolBarManager().find(SINGLEVALUEACTIONID);
            this.editAction = (ActionContributionItem)bars.getToolBarManager().find(EDITACTIONID);
            if (this.editAction != null) {
                ((EditAction)this.editAction.getAction()).setSource(this);
            }
            if (this.changeModeAction != null) {
                return;
            }
            this.changeModeAction = new ActionContributionItem((IAction)new Action(DisplayMode.REPO.getText(), 4){

                public String getId() {
                    return RepositoryPropertySource.CHANGEMODEACTIONID;
                }

                public void run() {
                    MenuManager mgr = new MenuManager();
                    ToolItem item = (ToolItem)RepositoryPropertySource.this.changeModeAction.getWidget();
                    ToolBar control = item.getParent();
                    Menu ctxMenu = mgr.createContextMenu((Control)control);
                    DisplayMode[] displayModeArray = DisplayMode.values();
                    int n = displayModeArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final DisplayMode aMode = displayModeArray[n2];
                        mgr.add((IAction)new Action(aMode.getText()){

                            public void run() {
                                RepositoryPropertySource.this.changeModeAction.getAction().setText(aMode.getText());
                                RepositoryPropertySource.this.editAction.getAction().setEnabled(aMode != DisplayMode.EFFECTIVE);
                                RepositoryPropertySource.this.myPage.refresh();
                            }

                            public boolean isEnabled() {
                                return aMode != RepositoryPropertySource.this.getCurrentMode();
                            }

                            public boolean isChecked() {
                                return aMode == RepositoryPropertySource.this.getCurrentMode();
                            }

                            public int getStyle() {
                                return 2;
                            }
                        });
                        ++n2;
                    }
                    ctxMenu.setVisible(true);
                }

                public String getToolTipText() {
                    return UIText.RepositoryPropertySource_SelectModeTooltip;
                }

                public int getStyle() {
                    return 4;
                }
            });
            this.editAction = new ActionContributionItem((IAction)new EditAction(UIText.RepositoryPropertySource_EditConfigButton, UIIcons.EDITCONFIG, this));
            this.singleValueToggleAction = new ActionContributionItem((IAction)new Action(UIText.RepositoryPropertySource_SingleValueButton){

                public String getId() {
                    return RepositoryPropertySource.SINGLEVALUEACTIONID;
                }

                public void run() {
                    RepositoryPropertySource.this.myPage.refresh();
                }

                public int getStyle() {
                    return 2;
                }

                public String getToolTipText() {
                    return UIText.RepositoryPropertySource_SuppressMultipleValueTooltip;
                }
            });
            bars.getToolBarManager().add((IContributionItem)new Separator());
            bars.getToolBarManager().add((IContributionItem)this.changeModeAction);
            bars.getToolBarManager().add((IContributionItem)this.singleValueToggleAction);
            bars.getToolBarManager().add((IContributionItem)this.editAction);
            bars.getToolBarManager().update(false);
        }
    }

    private DisplayMode getCurrentMode() {
        String actionText = this.changeModeAction.getAction().getText();
        DisplayMode[] displayModeArray = DisplayMode.values();
        int n = displayModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DisplayMode aMode = displayModeArray[n2];
            if (aMode.getText().equals(actionText)) {
                return aMode;
            }
            ++n2;
        }
        return null;
    }

    private boolean getSingleValueMode() {
        if (this.singleValueToggleAction != null) {
            return this.singleValueToggleAction.getAction().isChecked();
        }
        return false;
    }

    private Object getValueFromConfig(Config config, String keyString) {
        String name;
        String subsection;
        String section;
        StringTokenizer tok = new StringTokenizer(keyString, ".");
        String[] valueList = null;
        if (tok.countTokens() == 2) {
            section = tok.nextToken();
            subsection = null;
            name = tok.nextToken();
        } else if (tok.countTokens() == 3) {
            section = tok.nextToken();
            subsection = tok.nextToken();
            name = tok.nextToken();
        } else {
            return "";
        }
        valueList = this.getSingleValueMode() ? new String[]{config.getString(section, subsection, name)} : config.getStringList(section, subsection, name);
        if (valueList == null || valueList.length == 0) {
            return null;
        }
        if (valueList.length == 1) {
            return valueList[0];
        }
        StringBuilder sb = new StringBuilder();
        String[] stringArray = valueList;
        int n = valueList.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            sb.append('[');
            sb.append(value);
            sb.append(']');
            ++n2;
        }
        return sb.toString();
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        StoredConfig config;
        String category;
        String prefix;
        try {
            this.systemConfig.load();
            this.userHomeConfig.load();
            this.repositoryConfig.load();
            this.effectiveConfig.load();
        }
        catch (IOException e) {
            this.showExceptionMessage(e);
        }
        catch (ConfigInvalidException e) {
            this.showExceptionMessage((Exception)((Object)e));
        }
        ArrayList<PropertyDescriptor> resultList = new ArrayList<PropertyDescriptor>();
        boolean recursive = false;
        switch (this.getCurrentMode()) {
            case EFFECTIVE: {
                prefix = EFFECTIVE_ID_PREFIX;
                category = UIText.RepositoryPropertySource_EffectiveConfigurationCategory;
                config = this.effectiveConfig;
                recursive = true;
                break;
            }
            case REPO: {
                prefix = REPO_ID_PREFIX;
                String location = "";
                if (this.repositoryConfig instanceof FileBasedConfig) {
                    location = ((FileBasedConfig)this.repositoryConfig).getFile().getAbsolutePath();
                }
                category = NLS.bind((String)UIText.RepositoryPropertySource_RepositoryConfigurationCategory, (Object)location);
                config = this.repositoryConfig;
                break;
            }
            case USER: {
                prefix = USER_ID_PREFIX;
                String location = this.userHomeConfig.getFile().getAbsolutePath();
                category = NLS.bind((String)UIText.RepositoryPropertySource_GlobalConfigurationCategory, (Object)location);
                config = this.userHomeConfig;
                break;
            }
            case SYSTEM: {
                prefix = SYSTEM_ID_PREFIX;
                String location = this.systemConfig.getFile().getAbsolutePath();
                category = NLS.bind((String)UIText.RepositoryPropertySource_GlobalConfigurationCategory, (Object)location);
                config = this.systemConfig;
                break;
            }
            default: {
                return new IPropertyDescriptor[0];
            }
        }
        for (String key : config.getSections()) {
            for (String sectionItem : config.getNames(key, recursive)) {
                String sectionId = String.valueOf(key) + "." + sectionItem;
                PropertyDescriptor desc = new PropertyDescriptor((Object)(String.valueOf(prefix) + sectionId), sectionId);
                desc.setCategory(category);
                resultList.add(desc);
            }
            for (String sub : config.getSubsections(key)) {
                for (String sectionItem : config.getNames(key, sub, recursive)) {
                    String sectionId = String.valueOf(key) + "." + sub + "." + sectionItem;
                    PropertyDescriptor desc = new PropertyDescriptor((Object)(String.valueOf(prefix) + sectionId), sectionId);
                    desc.setCategory(category);
                    resultList.add(desc);
                }
            }
        }
        return resultList.toArray(new IPropertyDescriptor[0]);
    }

    public Object getPropertyValue(Object id) {
        String actId = (String)id;
        Object value = null;
        if (actId.startsWith(SYSTEM_ID_PREFIX)) {
            value = this.getValueFromConfig((Config)this.systemConfig, actId.substring(4));
        } else if (actId.startsWith(USER_ID_PREFIX)) {
            value = this.getValueFromConfig((Config)this.userHomeConfig, actId.substring(4));
        } else if (actId.startsWith(REPO_ID_PREFIX)) {
            value = this.getValueFromConfig((Config)this.repositoryConfig, actId.substring(4));
        } else if (actId.startsWith(EFFECTIVE_ID_PREFIX)) {
            value = this.getValueFromConfig((Config)this.effectiveConfig, actId.substring(4));
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    public boolean isPropertySet(Object id) {
        return false;
    }

    public void resetPropertyValue(Object id) {
    }

    public void setPropertyValue(Object id, Object value) {
    }

    private void showExceptionMessage(Exception e) {
        Activator.handleError(UIText.RepositoryPropertySource_ErrorHeader, e, true);
    }

    private static enum DisplayMode {
        EFFECTIVE(UIText.RepositoryPropertySource_EffectiveConfigurationAction),
        SYSTEM(UIText.RepositoryPropertySource_SystemConfigurationMenu),
        USER(UIText.RepositoryPropertySource_GlobalConfigurationMenu),
        REPO(UIText.RepositoryPropertySource_RepositoryConfigurationButton);

        private final String text;

        String getText() {
            return this.text;
        }

        private DisplayMode(String text) {
            this.text = text;
        }
    }

    private static class EditAction
    extends Action {
        private RepositoryPropertySource source;

        public EditAction(String text, ImageDescriptor image, RepositoryPropertySource source) {
            super(text, image);
            this.source = source;
        }

        public EditAction setSource(RepositoryPropertySource source) {
            this.source = source;
            return this;
        }

        public String getId() {
            return RepositoryPropertySource.EDITACTIONID;
        }

        public void run() {
            FileBasedConfig config;
            DisplayMode mode = this.source.getCurrentMode();
            switch (mode) {
                case EFFECTIVE: {
                    return;
                }
                case SYSTEM: {
                    config = this.source.systemConfig;
                    break;
                }
                case USER: {
                    config = this.source.userHomeConfig;
                    break;
                }
                case REPO: {
                    config = this.source.repositoryConfig;
                    break;
                }
                default: {
                    return;
                }
            }
            new EditDialog(this.source.myPage.getSite().getShell(), config, mode.getText()).open();
            this.source.myPage.refresh();
        }

        public int getStyle() {
            return 1;
        }
    }

    private static final class EditDialog
    extends TitleAreaDialog {
        private final FileBasedConfig myConfig;
        private final String myTitle;
        ConfigurationEditorComponent editor;

        public EditDialog(Shell shell, FileBasedConfig config, String title) {
            super(shell);
            this.myConfig = config;
            this.setShellStyle(this.getShellStyle() | 0x4F0);
            this.myTitle = title;
            this.setHelpAvailable(false);
        }

        protected Control createDialogArea(Composite parent) {
            Composite main = (Composite)super.createDialogArea(parent);
            GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)main);
            this.editor = new ConfigurationEditorComponent(main, (StoredConfig)this.myConfig, true){

                @Override
                protected void setErrorMessage(String message) {
                    EditDialog.this.setErrorMessage(message);
                }

                @Override
                protected void setDirty(boolean dirty) {
                    EditDialog.this.getButton(0).setEnabled(dirty);
                }
            };
            Control result = this.editor.createContents();
            EditDialog.applyDialogFont((Control)main);
            return result;
        }

        protected void configureShell(Shell newShell) {
            super.configureShell(newShell);
            newShell.setText(UIText.RepositoryPropertySource_EditConfigurationTitle);
            newShell.setSize(700, 600);
        }

        public void create() {
            super.create();
            this.setTitle(this.myTitle);
            this.setMessage(UIText.RepositoryPropertySource_EditorMessage);
            this.getButton(0).setEnabled(false);
        }

        protected void okPressed() {
            try {
                this.editor.save();
                super.okPressed();
            }
            catch (IOException e) {
                Activator.handleError(e.getMessage(), e, true);
            }
        }
    }
}

