/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.egit.core.internal.indexdiff.IndexDiffData;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.decorators.DecoratableResource;
import org.eclipse.egit.ui.internal.decorators.DecoratableResourceHelper;
import org.eclipse.egit.ui.internal.decorators.GitLightweightDecorator;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkingSet;

public class DecoratableResourceMapping
extends DecoratableResource {
    private static final String MULTIPLE = "*";
    public static final int RESOURCE_MAPPING = 16;
    public static final int WORKING_SET = 39321;
    private ResourceMapping mapping;

    public DecoratableResourceMapping(ResourceMapping mapping) throws IOException {
        super(null);
        this.mapping = mapping;
        IProject[] projects = mapping.getProjects();
        if (projects == null || projects.length == 0) {
            return;
        }
        HashSet<Repository> repositories = new HashSet<Repository>(projects.length);
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IndexDiffData diffData;
            IProject prj = iProjectArray[n2];
            RepositoryMapping repoMapping = RepositoryMapping.getMapping((IProject)prj);
            if (repoMapping != null && (diffData = GitLightweightDecorator.getIndexDiffDataOrNull((IResource)prj)) != null) {
                this.tracked = true;
                Repository repository = repoMapping.getRepository();
                String repoRelative = String.valueOf(this.makeRepoRelative(repository, (IResource)prj)) + "/";
                Set modified = diffData.getModified();
                Set conflicting = diffData.getConflicting();
                if (this.containsPrefix(modified, repoRelative)) {
                    this.dirty = true;
                }
                if (this.containsPrefix(conflicting, repoRelative)) {
                    this.conflicts = true;
                }
                repositories.add(repository);
            }
            ++n2;
        }
        if (repositories.size() == 1) {
            Repository repository = (Repository)repositories.iterator().next();
            this.repositoryName = DecoratableResourceHelper.getRepositoryName(repository);
            this.branch = DecoratableResourceHelper.getShortBranch(repository);
            this.branchStatus = DecoratableResourceHelper.getBranchStatus(repository);
        } else if (repositories.size() > 1) {
            HashSet<String> branches = new HashSet<String>(2);
            for (Repository repository : repositories) {
                branches.add(DecoratableResourceHelper.getShortBranch(repository));
                if (branches.size() > 1) break;
            }
            if (branches.size() == 1) {
                this.repositoryName = MULTIPLE;
                this.branch = (String)branches.iterator().next();
            }
        }
    }

    @Override
    public int getType() {
        if (this.mapping.getModelObject() instanceof IWorkingSet) {
            return 39321;
        }
        return 16;
    }

    @Override
    public String getName() {
        if (this.mapping.getModelObject() instanceof IWorkingSet) {
            IWorkingSet ws = (IWorkingSet)this.mapping.getModelObject();
            return ws.getLabel();
        }
        return "<unknown>";
    }

    private String makeRepoRelative(Repository repository, IResource res) {
        return Repository.stripWorkDir((File)repository.getWorkTree(), (File)res.getLocation().toFile());
    }

    private boolean containsPrefix(Set<String> collection, String prefix) {
        if (prefix.length() == 1 && !collection.isEmpty()) {
            return true;
        }
        for (String path : collection) {
            if (!path.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

