/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jpt.common.ui.internal.WorkbenchTools;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.ui.JptJaxbUiMessages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.part.FileEditorInput;

public class OpenJaxbResourceAction
extends BaseSelectionListenerAction {
    private JaxbContextNode selectedNode;

    public OpenJaxbResourceAction() {
        super("Open");
    }

    public boolean updateSelection(IStructuredSelection s) {
        this.selectedNode = null;
        if (!super.updateSelection(s)) {
            return false;
        }
        if (s.size() != 1) {
            return false;
        }
        if (s.getFirstElement() instanceof JaxbContextRoot) {
            return false;
        }
        this.selectedNode = (JaxbContextNode)s.getFirstElement();
        return true;
    }

    public void run() {
        if (!this.isEnabled()) {
            return;
        }
        IResource resource = this.selectedNode.getResource();
        if (resource != null && resource.exists() && resource.getType() == 1) {
            this.openEditor((IFile)resource);
        }
    }

    protected void openEditor(IFile file) {
        IEditorDescriptor editorDescriptor = WorkbenchTools.getDefaultEditor((IFile)file);
        if (editorDescriptor == null) {
            return;
        }
        IWorkbenchPage page = WorkbenchTools.getActivePage();
        try {
            if (page != null) {
                page.openEditor((IEditorInput)new FileEditorInput(file), editorDescriptor.getId());
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)JptJaxbUiMessages.ERROR_OPENING_EDITOR, (String)e.getMessage());
        }
    }
}

