/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.type.asm;

import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.asm.AnnotationVisitor;
import org.springframework.asm.Attribute;
import org.springframework.asm.ClassVisitor;
import org.springframework.asm.FieldVisitor;
import org.springframework.asm.MethodVisitor;
import org.springframework.ide.eclipse.core.type.ClassMetadata;
import org.springframework.ide.eclipse.core.type.asm.EmptyAnnotationVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyFieldVisitor;
import org.springframework.ide.eclipse.core.type.asm.EmptyMethodVisitor;
import org.springframework.util.ClassUtils;

public class ClassMetadataReadingVisitor
extends ClassVisitor
implements ClassMetadata {
    private String className;
    private boolean isInterface;
    private boolean isAnnotation;
    private boolean isAbstract;
    private boolean isFinal;
    private String enclosingClassName;
    private boolean independentInnerClass;
    private String superClassName;
    private String[] interfaces;
    private Set<String> memberClassNames = new LinkedHashSet<String>();

    public ClassMetadataReadingVisitor() {
        super(327680);
    }

    public void visit(int version, int access, String name, String signature, String supername, String[] interfaces) {
        this.className = ClassUtils.convertResourcePathToClassName((String)name);
        this.isInterface = (access & 0x200) != 0;
        this.isAnnotation = (access & 0x2000) != 0;
        this.isAbstract = (access & 0x400) != 0;
        boolean bl = this.isFinal = (access & 0x10) != 0;
        if (supername != null) {
            this.superClassName = ClassUtils.convertResourcePathToClassName((String)supername);
        }
        this.interfaces = new String[interfaces.length];
        int i = 0;
        while (i < interfaces.length) {
            this.interfaces[i] = ClassUtils.convertResourcePathToClassName((String)interfaces[i]);
            ++i;
        }
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.enclosingClassName = ClassUtils.convertResourcePathToClassName((String)owner);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (outerName != null) {
            String fqName = ClassUtils.convertResourcePathToClassName((String)name);
            String fqOuterName = ClassUtils.convertResourcePathToClassName((String)outerName);
            if (this.className.equals(fqName)) {
                this.enclosingClassName = fqOuterName;
                this.independentInnerClass = (access & 8) != 0;
            } else if (this.className.equals(fqOuterName)) {
                this.memberClassNames.add(fqName);
            }
        }
    }

    public void visitSource(String source, String debug) {
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return new EmptyAnnotationVisitor();
    }

    public void visitAttribute(Attribute attr) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return new EmptyFieldVisitor();
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return new EmptyMethodVisitor();
    }

    public void visitEnd() {
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAnnotation() {
        return this.isAnnotation;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isConcrete() {
        return !this.isInterface && !this.isAbstract;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public boolean isIndependent() {
        return this.enclosingClassName == null || this.independentInnerClass;
    }

    public boolean hasEnclosingClass() {
        return this.enclosingClassName != null;
    }

    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    @Override
    public boolean hasSuperClass() {
        return this.superClassName != null;
    }

    @Override
    public String getSuperClassName() {
        return this.superClassName;
    }

    @Override
    public String[] getInterfaceNames() {
        return this.interfaces;
    }

    public String[] getMemberClassNames() {
        return this.memberClassNames.toArray(new String[this.memberClassNames.size()]);
    }
}

