/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.project;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.springframework.core.OrderComparator;
import org.springframework.ide.eclipse.core.SpringCore;
import org.springframework.ide.eclipse.core.project.IProjectContributionEventListener;

public class ProjectContributionEventListenerFactory {
    public static final String LISTENERS_EXTENSION_POINT = "org.springframework.ide.eclipse.core.listeners";
    public static List<IProjectContributionEventListener> listenerDefinitions;

    public static synchronized List<IProjectContributionEventListener> getProjectContributionEventListeners() {
        if (listenerDefinitions == null) {
            listenerDefinitions = new ArrayList<IProjectContributionEventListener>();
            IExtension[] iExtensionArray = Platform.getExtensionRegistry().getExtensionPoint(LISTENERS_EXTENSION_POINT).getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    try {
                        Object listener = element.createExecutableExtension("class");
                        if (listener instanceof IProjectContributionEventListener) {
                            listenerDefinitions.add((IProjectContributionEventListener)listener);
                        }
                    }
                    catch (CoreException e) {
                        SpringCore.log(e);
                    }
                    ++n4;
                }
                ++n2;
            }
            OrderComparator.sort(listenerDefinitions);
        }
        return listenerDefinitions;
    }
}

