/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.core.java.classreading;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.springframework.asm.Type;
import org.springframework.core.type.MethodMetadata;
import org.springframework.core.type.classreading.MethodMetadataReadingVisitor;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.java.classreading.JdtConnectedMetadata;
import org.springframework.ide.eclipse.core.model.java.JavaModelMethodSourceLocation;
import org.springframework.ide.eclipse.core.model.java.JavaModelSourceLocation;

public class JdtConnectedMethodMetadataReadingVisitor
extends MethodMetadataReadingVisitor
implements JdtConnectedMetadata {
    private final String desc;
    private final String name;
    private final IType mainType;
    private final String returnType;
    private IMethod method;

    public JdtConnectedMethodMetadataReadingVisitor(IType mainType, String name, int access, String desc, String declaringClassName, ClassLoader classLoader, Set<MethodMetadata> methodMetadataMap, String returnType) {
        super(name, access, declaringClassName, classLoader, methodMetadataMap);
        this.mainType = mainType;
        this.desc = desc;
        this.name = name;
        this.returnType = returnType;
        this.method = null;
    }

    @Override
    public IJavaElement getJavaElement() {
        if (this.method == null) {
            this.method = this.getMethodFromSignature(this.name, this.desc);
        }
        return this.method;
    }

    @Override
    public JavaModelSourceLocation createSourceLocation() throws JavaModelException {
        return new JavaModelMethodSourceLocation(this.getJavaElement(), this.returnType);
    }

    private IMethod getMethodFromSignature(String name, String desc) {
        if (System.getProperty("spring-tooling.scanning.verbose", "false").equals("true")) {
            System.out.println("spring-tooling.scanning - findMethodFromSignature - type: " + this.mainType.getFullyQualifiedName() + " - method: " + name + " - signature: " + desc);
        }
        Type[] parameterTypes = Type.getArgumentTypes((String)desc);
        IMethod method = null;
        method = this.isConstructor(name) ? this.quickCheckForConstructor(parameterTypes) : this.quickCheckForMethod(name, parameterTypes);
        if (method == null) {
            ArrayList<String> parameters = new ArrayList<String>();
            if (parameterTypes != null && parameterTypes.length > 0) {
                Type[] typeArray = parameterTypes;
                int n = parameterTypes.length;
                int n2 = 0;
                while (n2 < n) {
                    Type parameterType = typeArray[n2];
                    parameters.add(parameterType.getClassName());
                    ++n2;
                }
            }
            if (this.isConstructor(name)) {
                method = JdtUtils.getConstructor(this.mainType, parameters.toArray(new String[parameters.size()]));
            } else {
                if (System.getProperty("spring-tooling.scanning.verbose", "false").equals("true")) {
                    System.out.println("spring-tooling.scanning - deep dive to find method - type: " + this.mainType.getFullyQualifiedName() + " - method: " + name + " - signature: " + desc);
                }
                method = JdtUtils.getMethod(this.mainType, name, parameters.toArray(new String[parameters.size()]), false);
            }
        }
        return method;
    }

    private boolean isConstructor(String name) {
        return "<init>".equals(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMethod quickCheckForMethod(String name, Type[] parameterTypes) {
        IMethod result = null;
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = this.mainType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result;
                }
                IMethod method = iMethodArray[n2];
                if (method.getElementName().equals(name) && method.getParameterTypes().length == parameterTypes.length) {
                    if (result != null) return null;
                    result = method;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private IMethod quickCheckForConstructor(Type[] parameterTypes) {
        IMethod result = null;
        try {
            IMethod[] methods;
            IMethod[] iMethodArray = methods = this.mainType.getMethods();
            int n = methods.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return result;
                }
                IMethod method = iMethodArray[n2];
                if (method.isConstructor() && method.getParameterTypes().length == parameterTypes.length) {
                    if (result != null) return null;
                    result = method;
                }
                ++n2;
            }
        }
        catch (JavaModelException javaModelException) {}
        return result;
    }
}

