/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.swt;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public abstract class ViewerSearchPart {
    private StructuredViewer viewer;
    private Text searchText;
    private String pattern;

    public ViewerSearchPart(Composite parent) {
        this.addPart(parent);
    }

    protected void addPart(Composite parent) {
        this.searchText = new Text(parent, 896);
        this.searchText.setBackground(null);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.searchText);
        this.searchText.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent event) {
                ViewerSearchPart.this.handleSearch(ViewerSearchPart.this.searchText.getText());
            }

            public void keyPressed(KeyEvent event) {
            }
        });
        this.searchText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (e.detail == 256) {
                    String searchString = ViewerSearchPart.this.searchText.getText();
                    ViewerSearchPart.this.handleSearch(searchString);
                }
            }
        });
        this.searchText.setMessage("Type pattern to match");
    }

    public void connectViewer(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    protected StructuredViewer getViewer() {
        return this.viewer;
    }

    protected void handleSearch(String search) {
        this.refreshFilter(search);
    }

    protected abstract boolean matches(Object var1, Object var2, String var3);

    protected ViewerFilter getViewerFilter() {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null) {
            return null;
        }
        ViewerFilter[] filters = viewer.getFilters();
        if (filters != null) {
            ViewerFilter[] viewerFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (filter instanceof CommonSearchFilter) {
                    return (CommonSearchFilter)filter;
                }
                ++n2;
            }
        }
        return null;
    }

    protected void refreshFilter(String searchPattern) {
        StructuredViewer viewer = this.getViewer();
        if (viewer == null) {
            return;
        }
        this.pattern = searchPattern;
        ViewerFilter patternFilter = this.getViewerFilter();
        if (patternFilter != null) {
            if (this.pattern == null || ViewerSearchPart.isAllWhitespace(this.pattern)) {
                viewer.removeFilter(patternFilter);
            } else {
                viewer.refresh(false);
            }
        } else if (this.pattern != null && !ViewerSearchPart.isAllWhitespace(this.pattern)) {
            this.getViewer().addFilter((ViewerFilter)new CommonSearchFilter());
        }
    }

    public Text getTextControl() {
        return this.searchText != null && !this.searchText.isDisposed() ? this.searchText : null;
    }

    public static boolean isAllWhitespace(String pattern) {
        if (pattern == null) {
            return false;
        }
        int i = 0;
        while (i < pattern.length()) {
            if (!Character.isWhitespace(pattern.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected class CommonSearchFilter
    extends ViewerFilter {
        protected CommonSearchFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (ViewerSearchPart.this.pattern == null || ViewerSearchPart.isAllWhitespace(ViewerSearchPart.this.pattern)) {
                return false;
            }
            return ViewerSearchPart.this.matches(element, parentElement, ViewerSearchPart.this.pattern);
        }
    }
}

