/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.springsource.ide.eclipse.commons.frameworks.core.internal.commands.ICommandParameter;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.AbstractParameterEditor;
import org.springsource.ide.eclipse.commons.frameworks.ui.internal.parameters.editors.UIEvent;

public class BaseParameterEditor
extends AbstractParameterEditor {
    private Text commandValueText;
    boolean firstFocus = true;
    protected static final int NUMBER_OF_COLUMNS = 2;
    private int uiEventType = UIEvent.VALUE_SET | UIEvent.CLEAR_VALUE_EVENT;

    public BaseParameterEditor(ICommandParameter parameter, boolean requiresLabel) {
        super(parameter, requiresLabel);
    }

    protected int numberOfTextControlCompositeColumns() {
        return 2;
    }

    @Override
    public Composite createControls(Composite parent) {
        Composite textControlComposite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(this.numberOfTextControlCompositeColumns()).margins(0, 0).applyTo(textControlComposite);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textControlComposite);
        this.commandValueText = new Text(textControlComposite, 2048);
        this.commandValueText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Object defaultValue = this.getParameter().getValue();
        if (defaultValue instanceof String) {
            this.commandValueText.setText((String)defaultValue);
        }
        this.commandValueText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BaseParameterEditor.this.notifyTextChange(BaseParameterEditor.this.commandValueText.getText());
            }
        });
        this.commandValueText.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (BaseParameterEditor.this.firstFocus) {
                    BaseParameterEditor.this.notifyTextChange(BaseParameterEditor.this.commandValueText.getText());
                    BaseParameterEditor.this.firstFocus = false;
                }
            }
        });
        return textControlComposite;
    }

    protected Text getTextControl() {
        return this.commandValueText;
    }

    protected void notifyTextChange(String text) {
        this.setParameterValue(text, this.uiEventType);
        this.uiEventType = UIEvent.VALUE_SET | UIEvent.CLEAR_VALUE_EVENT;
    }

    @Override
    protected void clearControls() {
        if (this.commandValueText != null && !this.commandValueText.isDisposed()) {
            this.uiEventType = UIEvent.VALUE_SET;
            this.commandValueText.setText("");
        }
    }
}

