/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.aop.core.internal.model.builder;

import java.util.List;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.aop.core.internal.model.JavaAdvisorDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AbstractAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.logging.AopLog;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.model.builder.IAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.model.builder.IDocumentFactory;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionalXmlAspectDefinitionBuilder
extends AbstractAspectDefinitionBuilder
implements IAspectDefinitionBuilder {
    private static final String TRANSACTION_INTERCEPTOR_CLASS = "org.springframework.transaction.interceptor.TransactionInterceptor";
    private static final String ANNOTATION_EXPRESSION = "(@within(org.springframework.transaction.annotation.Transactional) || @annotation(org.springframework.transaction.annotation.Transactional)) && execution(* *..*(..))";
    private static final String TX_NAMESPACE_URI = "http://www.springframework.org/schema/tx";

    @Override
    public void buildAspectDefinitions(List<IAspectDefinition> aspectInfos, IFile file, IProjectClassLoaderSupport classLoaderSupport, IDocumentFactory factory) {
        if (file.getFileExtension() != null && file.getFileExtension().equals("xml")) {
            this.parseAnnotationDrivenElement(factory.createDocument(file), file, aspectInfos, classLoaderSupport);
        }
    }

    private void addAspectDefinition(IAspectDefinition info, List<IAspectDefinition> aspectInfos) {
        AopLog.log(4, info.toString());
        aspectInfos.add(info);
    }

    private void parseAnnotationDrivenElement(IDOMDocument document, IFile file, List<IAspectDefinition> aspectInfos, IProjectClassLoaderSupport classLoaderSupport) {
        if (document == null || document.getStructuredDocument() == null) {
            return;
        }
        NodeList list = document.getDocumentElement().getElementsByTagNameNS(TX_NAMESPACE_URI, "annotation-driven");
        int i = 0;
        while (i < list.getLength()) {
            Node node = list.item(i);
            String mode = this.getAttribute(node, "mode");
            if (!StringUtils.hasText((String)mode) || "proxy".equals(mode)) {
                String isProxyTargetClass = this.getAttribute(node, "proxy-target-class");
                this.addAspectDefinition(this.createAnnotationInfo(file, node, isProxyTargetClass), aspectInfos);
            }
            ++i;
        }
    }

    private IAspectDefinition createAnnotationInfo(IFile file, Node node, String isProxyTargetClass) {
        JavaAdvisorDefinition info = this.prepareJavaAdvisorDefinition(file, node, ANNOTATION_EXPRESSION);
        info.setProxyTargetClass("true".equalsIgnoreCase(isProxyTargetClass));
        return info;
    }

    private JavaAdvisorDefinition prepareJavaAdvisorDefinition(IFile file, Node aspectNode, String pointcutExpression) {
        Set beans;
        JavaAdvisorDefinition info = new JavaAdvisorDefinition();
        this.extractLineNumbers(info, (IDOMNode)aspectNode);
        info.setPointcutExpression(pointcutExpression);
        info.setAspectClassName(TRANSACTION_INTERCEPTOR_CLASS);
        IBeansConfig config = BeansCorePlugin.getModel().getConfig(file);
        if (config != null && (beans = config.getBeans(TRANSACTION_INTERCEPTOR_CLASS)).size() > 0) {
            for (IBean bean : beans) {
                if (info.getAspectStartLineNumber() > bean.getElementStartLine() || info.getAspectEndLineNumber() < bean.getElementEndLine()) continue;
                info.setAspectName(bean.getElementName());
                break;
            }
        }
        info.setType(IAopReference.ADVICE_TYPE.AROUND);
        info.setAdviceMethodName("invoke");
        info.setAdviceMethodParameterTypes(new String[]{MethodInvocation.class.getName()});
        info.setResource((IResource)file);
        return info;
    }
}

