/*
 * Decompiled with CFR 0.152.
 */
package com.github.sevntu.checkstyle.checks.coding;

import com.github.sevntu.checkstyle.Utils;
import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class EmptyPublicCtorInClassCheck
extends Check {
    public static final String MSG_KEY = "empty.public.ctor";
    private List<String> singleTypeImports = new ArrayList<String>();
    private List<String> onDemandImports = new ArrayList<String>();
    private String filePackageName;
    private Pattern classAnnotationNames = Pattern.compile("javax\\.persistence\\.Entity");
    private Pattern ctorAnnotationNames = Pattern.compile("com\\.google\\.inject\\.Inject");

    public void setClassAnnotationNames(String regex) {
        this.classAnnotationNames = regex != null && !regex.isEmpty() ? Pattern.compile(regex) : null;
    }

    public void setCtorAnnotationNames(String regex) {
        this.ctorAnnotationNames = regex != null && !regex.isEmpty() ? Pattern.compile(regex) : null;
    }

    public int[] getDefaultTokens() {
        return new int[]{14, 16, 30};
    }

    public void beginTree(DetailAST aRootNode) {
        this.singleTypeImports.clear();
        this.onDemandImports.clear();
        this.filePackageName = "";
    }

    public void visitToken(DetailAST node) {
        switch (node.getType()) {
            case 30: {
                String packageMemberName = EmptyPublicCtorInClassCheck.getIdentifierName(node);
                if (EmptyPublicCtorInClassCheck.isOnDemandImport(packageMemberName)) {
                    this.onDemandImports.add(packageMemberName);
                    break;
                }
                this.singleTypeImports.add(packageMemberName);
                break;
            }
            case 14: {
                DetailAST ctorDef;
                if (EmptyPublicCtorInClassCheck.getClassCtorCount(node) != 1 || !EmptyPublicCtorInClassCheck.isCtorPublic(ctorDef = EmptyPublicCtorInClassCheck.getFirstCtorDefinition(node)) || !EmptyPublicCtorInClassCheck.isCtorHasNoParameters(ctorDef) || !EmptyPublicCtorInClassCheck.isCtorHasNoStatements(ctorDef) || this.isClassHasRegisteredAnnotation(node) || this.isCtorHasRegisteredAnnotation(ctorDef)) break;
                this.log(ctorDef, MSG_KEY, new Object[0]);
                break;
            }
            case 16: {
                this.filePackageName = EmptyPublicCtorInClassCheck.getIdentifierName(node);
                break;
            }
            default: {
                Utils.reportInvalidToken(node.getType());
            }
        }
    }

    private static int getClassCtorCount(DetailAST classDefNode) {
        return classDefNode.findFirstToken(6).getChildCount(8);
    }

    private static DetailAST getFirstCtorDefinition(DetailAST classDefNode) {
        return classDefNode.findFirstToken(6).findFirstToken(8);
    }

    private static boolean isCtorPublic(DetailAST ctorDefNode) {
        return ctorDefNode.findFirstToken(5).findFirstToken(62) != null;
    }

    private static boolean isCtorHasNoParameters(DetailAST ctorDefNode) {
        return ctorDefNode.findFirstToken(20).getChildCount() == 0;
    }

    private static boolean isCtorHasNoStatements(DetailAST ctorDefNode) {
        return ctorDefNode.findFirstToken(7).getChildCount() == 1;
    }

    private boolean isClassHasRegisteredAnnotation(DetailAST classDefNode) {
        List<String> annotationNames = this.getAnnotationCanonicalNames(classDefNode);
        return EmptyPublicCtorInClassCheck.isAnyOfNamesMatches(annotationNames, this.classAnnotationNames);
    }

    private boolean isCtorHasRegisteredAnnotation(DetailAST ctorDefNode) {
        List<String> annotationNames = this.getAnnotationCanonicalNames(ctorDefNode);
        return EmptyPublicCtorInClassCheck.isAnyOfNamesMatches(annotationNames, this.ctorAnnotationNames);
    }

    private static boolean isAnyOfNamesMatches(List<String> annotationNames, Pattern pattern) {
        if (pattern == null) {
            return false;
        }
        for (String annotationName : annotationNames) {
            if (!pattern.matcher(annotationName).matches()) continue;
            return true;
        }
        return false;
    }

    private List<String> getAnnotationCanonicalNames(DetailAST node) {
        ArrayList<String> annotationNames = new ArrayList<String>();
        for (DetailAST modifierNode = node.findFirstToken(5).getFirstChild(); modifierNode != null; modifierNode = modifierNode.getNextSibling()) {
            if (modifierNode.getType() != 159) continue;
            String annotationName = EmptyPublicCtorInClassCheck.getIdentifierName(modifierNode);
            List<String> annotationPossibleCanonicalNames = this.generateAnnotationPossibleCanonicalNames(annotationName);
            annotationNames.add(annotationName);
            annotationNames.addAll(annotationPossibleCanonicalNames);
        }
        return annotationNames;
    }

    private static boolean isOnDemandImport(String importTargetName) {
        return importTargetName.endsWith(".*");
    }

    private List<String> generateAnnotationPossibleCanonicalNames(String annotationName) {
        String annotationCanonicalName;
        ArrayList<String> annotationPossibleCanonicalNames = new ArrayList<String>();
        for (String importEntry : this.singleTypeImports) {
            annotationCanonicalName = EmptyPublicCtorInClassCheck.joinSingleTypeImportWithIdentifier(importEntry, annotationName);
            if (annotationCanonicalName == null) continue;
            annotationPossibleCanonicalNames.add(annotationCanonicalName);
            break;
        }
        for (String importEntry : this.onDemandImports) {
            annotationCanonicalName = EmptyPublicCtorInClassCheck.joinOnDemandImportWithIdentifier(importEntry, annotationName);
            annotationPossibleCanonicalNames.add(annotationCanonicalName);
        }
        String annotationCanonicalName2 = EmptyPublicCtorInClassCheck.joinFilePackageNameWithIdentifier(this.filePackageName, annotationName);
        annotationPossibleCanonicalNames.add(annotationCanonicalName2);
        return annotationPossibleCanonicalNames;
    }

    private static String joinSingleTypeImportWithIdentifier(String importEntry, String identifierName) {
        String annotationNameFirstPart;
        String importEntryLastPart = EmptyPublicCtorInClassCheck.getSimpleIdentifierNameFromQualifiedName(importEntry);
        if (importEntryLastPart.equals(annotationNameFirstPart = EmptyPublicCtorInClassCheck.getQualifiedNameFirstPart(identifierName))) {
            return importEntry + identifierName.substring(annotationNameFirstPart.length());
        }
        return null;
    }

    private static String joinOnDemandImportWithIdentifier(String importEntry, String identifierName) {
        return importEntry.substring(0, importEntry.length() - 1) + identifierName;
    }

    private static String joinFilePackageNameWithIdentifier(String packageName, String identifierName) {
        return packageName + "." + identifierName;
    }

    private static String getQualifiedNameFirstPart(String canonicalName) {
        int firstDotIndex = canonicalName.indexOf(46);
        if (firstDotIndex == -1) {
            return canonicalName;
        }
        return canonicalName.substring(0, firstDotIndex);
    }

    private static String getSimpleIdentifierNameFromQualifiedName(String qualifiedName) {
        return qualifiedName.substring(qualifiedName.lastIndexOf(46) + 1);
    }

    private static String getIdentifierName(DetailAST identifierNode) {
        String result;
        DetailAST identNode = identifierNode.findFirstToken(58);
        if (identNode != null) {
            result = identNode.getText();
        } else {
            StringBuilder builder = new StringBuilder(40);
            DetailAST node = identifierNode.findFirstToken(59);
            while (node.getType() == 59) {
                builder.insert(0, '.').insert(1, node.getLastChild().getText());
                node = node.getFirstChild();
            }
            builder.insert(0, node.getText());
            result = builder.toString();
        }
        return result;
    }
}

