/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.data.jdt.core;

import org.eclipse.jdt.core.IField;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.mapping.PropertyReferenceException;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.util.Assert;

class QueryMethodPart {
    private final String source;
    private PropertyPath path;
    private String seed;
    private Part.Type type;

    public QueryMethodPart(String source, Class<?> domainType) {
        this.source = source;
        if (source != null && source.length() > 0) {
            try {
                Part part = new Part(source, domainType);
                this.path = part.getProperty();
                this.seed = null;
                this.type = part.getType();
            }
            catch (PropertyReferenceException e) {
                this.path = e.getBaseProperty();
                this.seed = e.getPropertyName();
                this.type = null;
            }
        }
    }

    public boolean isCompletePathMatch() {
        return this.path != null && this.seed == null;
    }

    public boolean isRoot() {
        return this.path == null;
    }

    public boolean isKeywordComplete() {
        if (!this.isCompletePathMatch()) {
            return false;
        }
        if (!this.type.equals((Object)Part.Type.SIMPLE_PROPERTY)) {
            return true;
        }
        for (String keyword : Part.Type.SIMPLE_PROPERTY.getKeywords()) {
            if (!this.source.endsWith(keyword)) continue;
            return true;
        }
        return false;
    }

    public PropertyPath getPathLeaf() {
        return this.path == null ? null : this.path.getLeafProperty();
    }

    public String getSeed() {
        return this.seed;
    }

    public String getKeyword() {
        if (!this.isCompletePathMatch()) {
            return null;
        }
        PropertyPath current = this.path;
        int index = this.path.getSegment().length();
        while (current.hasNext()) {
            current = current.next();
            index += current.getSegment().length();
        }
        return this.source.length() == index ? null : this.source.substring(index);
    }

    public boolean isProposalCandidate(IField field) {
        Assert.notNull((Object)field);
        return this.seed == null ? true : field.getElementName().startsWith(this.seed);
    }
}

