/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteringContainerList
implements Iterable<IContainer> {
    private SortedMap<String, IContainer> containers = new TreeMap<String, IContainer>();

    public FilteringContainerList() {
    }

    public FilteringContainerList(Collection<IResource> resources) {
        this.addAll(resources);
    }

    @Override
    public Iterator<IContainer> iterator() {
        return new FilteringContainerListIterator(new TreeMap<String, IContainer>(this.containers));
    }

    public void add(IContainer container) {
        this.containers.put(container.getFullPath().toString(), container);
    }

    public void add(IResource resource) {
        IContainer container = resource instanceof IContainer ? (IContainer)resource : resource.getParent();
        this.containers.put(container.getFullPath().toString(), container);
    }

    public void addAll(Collection<IResource> resources) {
        if (resources == null) {
            return;
        }
        for (IResource resource : resources) {
            this.add(resource);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FilteringContainerListIterator
    implements Iterator<IContainer> {
        private SortedMap<String, IContainer> containers = new TreeMap<String, IContainer>();

        FilteringContainerListIterator(SortedMap<String, IContainer> containers) {
            this.containers = containers;
        }

        @Override
        public boolean hasNext() {
            return !this.containers.isEmpty();
        }

        @Override
        public IContainer next() {
            String key = this.containers.firstKey();
            IContainer result = (IContainer)this.containers.get(key);
            this.containers.remove(key);
            key = String.valueOf(key) + "/";
            SortedMap<String, IContainer> childs = this.containers.tailMap(key);
            Iterator<String> it = childs.keySet().iterator();
            while (it.hasNext()) {
                if (!it.next().startsWith(key)) break;
                it.remove();
            }
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

