/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.subclipse.core.resources;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tigris.subversion.subclipse.core.ISVNRemoteFolder;
import org.tigris.subversion.subclipse.core.ISVNRemoteResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.Policy;
import org.tigris.subversion.subclipse.core.SVNException;
import org.tigris.subversion.subclipse.core.repo.ISVNListener;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class RepositoryResourcesManager {
    private List<ISVNListener> repositoryListeners = new ArrayList<ISVNListener>();

    public void addRepositoryListener(ISVNListener listener) {
        this.repositoryListeners.add(listener);
    }

    public void removeRepositoryListener(ISVNListener listener) {
        this.repositoryListeners.remove(listener);
    }

    public void repositoryRemoved(ISVNRepositoryLocation repository) {
        for (ISVNListener listener : this.repositoryListeners) {
            listener.repositoryRemoved(repository);
        }
    }

    public void repositoryAdded(ISVNRepositoryLocation repository) {
        for (ISVNListener listener : this.repositoryListeners) {
            listener.repositoryAdded(repository);
        }
    }

    public void repositoryModified(ISVNRepositoryLocation repository) {
        for (ISVNListener listener : this.repositoryListeners) {
            listener.repositoryModified(repository);
        }
    }

    public void remoteResourceCreated(ISVNRemoteFolder parent, String resourceName) {
        for (ISVNListener listener : this.repositoryListeners) {
            listener.remoteResourceCreated(parent, resourceName);
        }
    }

    public void remoteResourceDeleted(ISVNRemoteResource resource) {
        for (ISVNListener listener : this.repositoryListeners) {
            listener.remoteResourceDeleted(resource);
        }
    }

    public void remoteResourceCopied(ISVNRemoteResource source, ISVNRemoteFolder destination) {
        for (ISVNListener listener : this.repositoryListeners) {
            listener.remoteResourceCopied(source, destination);
        }
    }

    public void remoteResourceMoved(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String destinationResourceName) {
        for (ISVNListener listener : this.repositoryListeners) {
            listener.remoteResourceMoved(resource, destinationFolder, destinationResourceName);
        }
    }

    public void createRemoteFolder(ISVNRemoteFolder parent, String folderName, String message, IProgressMonitor monitor) throws SVNException {
        parent.createRemoteFolder(folderName, message, monitor);
    }

    public void deleteRemoteResources(ISVNRemoteResource[] remoteResources, String message, IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RepositoryResourcesManager.deleteRemoteResources"), 100 * remoteResources.length);
        HashMap<ISVNRepositoryLocation, ArrayList<ISVNRemoteResource>> mapRepositories = new HashMap<ISVNRepositoryLocation, ArrayList<ISVNRemoteResource>>();
        ISVNRemoteResource[] iSVNRemoteResourceArray = remoteResources;
        int n = 0;
        int n2 = iSVNRemoteResourceArray.length;
        while (n < n2) {
            ISVNRemoteResource remoteResource = iSVNRemoteResourceArray[n];
            ISVNRepositoryLocation repositoryLocation = remoteResource.getRepository();
            ArrayList<ISVNRemoteResource> resources = (ArrayList<ISVNRemoteResource>)mapRepositories.get(repositoryLocation);
            if (resources == null) {
                resources = new ArrayList<ISVNRemoteResource>();
                mapRepositories.put(repositoryLocation, resources);
            }
            resources.add(remoteResource);
            ++n;
        }
        ISVNClientAdapter svnClient = null;
        ISVNRepositoryLocation repository = null;
        try {
            try {
                for (List resources : mapRepositories.values()) {
                    repository = ((ISVNRemoteResource)resources.get(0)).getRepository();
                    svnClient = repository.getSVNClient();
                    SVNUrl[] urls = new SVNUrl[resources.size()];
                    int i = 0;
                    while (i < resources.size()) {
                        ISVNRemoteResource resource = (ISVNRemoteResource)resources.get(i);
                        urls[i] = resource.getUrl();
                        resource.getParent().refresh();
                        ++i;
                    }
                    svnClient.remove(urls, message);
                    repository.returnSVNClient(svnClient);
                    svnClient = null;
                    repository = null;
                    for (ISVNRemoteResource resource : resources) {
                        this.remoteResourceDeleted(resource);
                    }
                    progress.worked(100 * urls.length);
                }
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            if (repository != null) {
                repository.returnSVNClient(svnClient);
            }
            progress.done();
        }
    }

    public void copyRemoteResource(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String message, IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RepositoryResourcesManager.copyRemoteResources"), 100);
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = resource.getRepository().getSVNClient();
                svnClient.copy(resource.getUrl(), destinationFolder.getUrl(), message, SVNRevision.HEAD);
                destinationFolder.refresh();
                this.remoteResourceCopied(resource, destinationFolder);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            resource.getRepository().returnSVNClient(svnClient);
            progress.done();
        }
    }

    public void moveRemoteResource(ISVNRemoteResource resource, ISVNRemoteFolder destinationFolder, String destinationResourceName, String message, IProgressMonitor monitor) throws SVNException {
        IProgressMonitor progress = Policy.monitorFor(monitor);
        progress.beginTask(Policy.bind("RepositoryResourcesManager.moveRemoteResources"), 100);
        ISVNClientAdapter svnClient = null;
        try {
            try {
                svnClient = resource.getRepository().getSVNClient();
                SVNUrl destUrl = destinationFolder.getUrl().appendPath(destinationResourceName);
                svnClient.move(resource.getUrl(), destUrl, message, SVNRevision.HEAD);
                resource.getParent().refresh();
                destinationFolder.refresh();
                this.remoteResourceMoved(resource, destinationFolder, destinationResourceName);
            }
            catch (SVNClientException e) {
                throw SVNException.wrapException((Exception)((Object)e));
            }
        }
        finally {
            resource.getRepository().returnSVNClient(svnClient);
            progress.done();
        }
    }
}

