/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.theplugin.commons.bamboo.api;

import com.atlassian.connector.commons.api.ConnectionCfg;
import com.atlassian.theplugin.commons.exception.HttpProxySettingsException;
import com.atlassian.theplugin.commons.remoteapi.CaptchaRequiredException;
import com.atlassian.theplugin.commons.remoteapi.ProductSession;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiLoginFailedException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiMalformedUrlException;
import com.atlassian.theplugin.commons.remoteapi.RemoteApiSessionExpiredException;
import com.atlassian.theplugin.commons.remoteapi.rest.AbstractHttpSession;
import com.atlassian.theplugin.commons.remoteapi.rest.HttpSessionCallback;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class LoginBambooSession
extends AbstractHttpSession
implements ProductSession {
    protected String authToken;
    private static final String AUTHENTICATION_ERROR_MESSAGE = "User not authenticated yet, or session timed out";
    private static final String LOGIN_ACTION = "/api/rest/login.action";
    private static final String LOGOUT_ACTION = "/api/rest/logout.action";

    public LoginBambooSession(ConnectionCfg serverData, HttpSessionCallback callback) throws RemoteApiMalformedUrlException {
        super(serverData, callback);
    }

    public void login(final String name, char[] aPassword) throws RemoteApiLoginException {
        String host = null;
        if (name == null || aPassword == null) {
            throw new RemoteApiLoginException("Corrupted configuration. Username or Password null");
        }
        final String pass = String.valueOf(aPassword);
        String loginUrl = String.valueOf(this.getBaseUrl()) + LOGIN_ACTION;
        try {
            try {
                host = new URL(this.getBaseUrl()).getHost();
            }
            catch (MalformedURLException e) {
                throw new RemoteApiException(e.getMessage(), e);
            }
            this.callback.getHttpClient(this.getServer()).getState().clearCookies();
            Document doc = this.retrievePostResponseInternalImpl(loginUrl, new AbstractHttpSession.PostMethodPreparer(){

                public void prepare(PostMethod login) throws UnsupportedEncodingException {
                    login.addRequestHeader("Accept", "application/xml;q=0.9,*/*");
                    login.addParameter("os_username", name);
                    login.addParameter("os_password", pass);
                    login.addParameter("username", name);
                    login.addParameter("password", pass);
                }
            }, true, 0, null);
            String exception = LoginBambooSession.getExceptionMessages(doc);
            if (exception != null) {
                throw new RemoteApiLoginFailedException(exception);
            }
            List elements = XPath.newInstance((String)"/response/auth").selectNodes((Object)doc);
            if (elements == null || elements.size() == 0) {
                throw new RemoteApiLoginException("Server did not return any authentication token");
            }
            if (elements.size() != 1) {
                throw new RemoteApiLoginException("Server returned unexpected number of authentication tokens (" + elements.size() + ")");
            }
            this.authToken = ((Element)elements.get(0)).getText();
        }
        catch (RemoteApiLoginFailedException e) {
            throw e;
        }
        catch (RemoteApiException e) {
            if (e.getCause() != null && e.getCause().getMessage().contains("maximum")) {
                throw new CaptchaRequiredException(e);
            }
            if (e.getCause() instanceof UnknownHostException) {
                throw new RemoteApiLoginException("Unknown host: " + host, e);
            }
            if (e.getCause() instanceof MalformedURLException) {
                throw new RemoteApiLoginException("Malformed server URL: " + this.getBaseUrl(), e);
            }
            throw new RemoteApiLoginException(e.getMessage(), e);
        }
        catch (JDOMException e) {
            throw new RemoteApiLoginException("Server returned malformed response", e);
        }
        catch (IllegalArgumentException e) {
            throw new RemoteApiLoginException("Malformed server URL: " + this.getBaseUrl(), e);
        }
        catch (HttpProxySettingsException e) {
            throw new RemoteApiLoginException(e.getMessage(), e);
        }
    }

    public void logout() {
        if (!this.isLoggedIn()) {
            return;
        }
        try {
            String logoutUrl = String.valueOf(this.getBaseUrl()) + LOGOUT_ACTION + "?auth=" + URLEncoder.encode(this.authToken, "UTF-8");
            this.retrieveGetResponse(logoutUrl);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("URLEncoding problem", e);
        }
        catch (IOException iOException) {
        }
        catch (JDOMException jDOMException) {
        }
        catch (RemoteApiSessionExpiredException remoteApiSessionExpiredException) {}
        this.authToken = null;
    }

    public boolean isLoggedIn() {
        return this.authToken != null;
    }

    protected void preprocessResult(Document doc) throws JDOMException, RemoteApiSessionExpiredException {
        String error = LoginBambooSession.getExceptionMessages(doc);
        if (error != null && error.startsWith(AUTHENTICATION_ERROR_MESSAGE)) {
            throw new RemoteApiSessionExpiredException("Session expired.");
        }
    }

    protected void preprocessMethodResult(HttpMethod method) {
    }

    protected static String getExceptionMessages(Document doc) throws JDOMException {
        XPath xpath = XPath.newInstance((String)"/errors/error");
        List elements = xpath.selectNodes((Object)doc);
        if (elements != null && elements.size() > 0) {
            StringBuffer exceptionMsg = new StringBuffer();
            for (Element e : elements) {
                exceptionMsg.append(e.getText());
                exceptionMsg.append("\n");
            }
            return exceptionMsg.toString();
        }
        return null;
    }

    protected void adjustHttpHeader(HttpMethod method) {
    }
}

