/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation.rules;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IType;
import org.springframework.binding.convert.ConversionService;
import org.springframework.binding.convert.support.DefaultConversionService;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;

public abstract class WebflowValidationRuleUtils {
    private static ConversionService conversionService = null;
    protected static final List<String> SCOPE_TYPES = new ArrayList<String>();

    static {
        SCOPE_TYPES.add("request");
        SCOPE_TYPES.add("flash");
        SCOPE_TYPES.add("flow");
        SCOPE_TYPES.add("conversation");
    }

    protected static IType getJavaType(String className, WebflowValidationContext context) {
        Class clazz;
        IType type = JdtUtils.getJavaType((IProject)context.getWebflowConfig().getProject().getProject(), (String)className);
        if (type == null && (clazz = WebflowValidationRuleUtils.getConversionService().getClassByAlias(className)) != null) {
            type = JdtUtils.getJavaType((IProject)context.getWebflowConfig().getProject().getProject(), (String)clazz.getName());
        }
        return type;
    }

    private static ConversionService getConversionService() {
        if (conversionService == null) {
            conversionService = new DefaultConversionService();
        }
        return conversionService;
    }
}

