/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.beans.core.BeansCorePlugin;
import org.springframework.ide.eclipse.beans.core.BeansCoreUtils;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfig;
import org.springframework.ide.eclipse.beans.core.model.IBeansConfigSet;
import org.springframework.ide.eclipse.core.java.JdtUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.ISpringProject;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidator;
import org.springframework.ide.eclipse.core.model.validation.IValidationContext;
import org.springframework.ide.eclipse.core.model.validation.IValidationElementLifecycleManager;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.validation.WebflowValidationContext;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;

public class WebflowValidator
extends AbstractValidator {
    public static final String VALIDATOR_ID = "org.springframework.ide.eclipse.webflow.core.validator";

    public Set<IResource> deriveResources(Object object) {
        IWebflowProject project;
        LinkedHashSet<IResource> resources = new LinkedHashSet<IResource>();
        if (object instanceof ISpringProject) {
            object = Activator.getModel().getProject(((ISpringProject)object).getProject());
        } else if (object instanceof IFile && (project = Activator.getModel().getProject(((IFile)object).getProject())) != null) {
            object = project.getConfig((IFile)object);
        }
        if (object instanceof IWebflowModelElement) {
            if (object instanceof IWebflowProject) {
                for (IWebflowConfig wc : ((IWebflowProject)object).getConfigs()) {
                    resources.add(wc.getElementResource());
                }
            } else if (object instanceof IResourceModelElement) {
                resources.add(((IResourceModelElement)object).getElementResource());
            }
        }
        return resources;
    }

    public Set<IResource> getAffectedResources(IResource resource, int kind, int deltaKind) throws CoreException {
        LinkedHashSet<IResource> resources;
        block6: {
            block7: {
                block5: {
                    resources = new LinkedHashSet<IResource>();
                    if (!WebflowModelUtils.isWebflowConfig(resource)) break block5;
                    resources.add(resource);
                    break block6;
                }
                if (!JdtUtils.isClassPathFile((IResource)resource)) break block7;
                IWebflowProject webflowProject = Activator.getModel().getProject(resource.getProject());
                if (webflowProject == null) break block6;
                for (IWebflowConfig config : webflowProject.getConfigs()) {
                    resources.add(config.getElementResource());
                }
                break block6;
            }
            if (BeansCoreUtils.isBeansConfig((IResource)resource)) {
                IBeansConfig bc = BeansCorePlugin.getModel().getConfig((IFile)resource);
                IWebflowProject wp = Activator.getModel().getProject(resource.getProject());
                for (IWebflowConfig fc : wp.getConfigs()) {
                    if (fc.getBeansConfigs().contains(bc)) {
                        resources.add(fc.getElementResource());
                    }
                    for (IModelElement me : fc.getBeansConfigs()) {
                        if (!(me instanceof IBeansConfigSet) || !((IBeansConfigSet)me).getConfigs().contains(bc)) continue;
                        resources.add(fc.getElementResource());
                    }
                }
            }
        }
        return resources;
    }

    protected IValidationContext createContext(IResourceModelElement rootElement, IResourceModelElement contextElement) {
        if (rootElement instanceof IWebflowState) {
            IWebflowState state = (IWebflowState)rootElement;
            IWebflowConfig config = WebflowModelUtils.getWebflowConfig((IFile)state.getElementResource());
            return new WebflowValidationContext(state, config);
        }
        return null;
    }

    protected boolean supports(IModelElement element) {
        return element instanceof IWebflowModelElement;
    }

    protected IValidationElementLifecycleManager createValidationElementLifecycleManager() {
        return new WebflowStateLifecycleManager();
    }

    private static class WebflowStateLifecycleManager
    implements IValidationElementLifecycleManager {
        private IStructuredModel model = null;
        private IFile file = null;
        private IWebflowState rootElement;

        private WebflowStateLifecycleManager() {
        }

        public void destroy() {
            if (this.model != null) {
                this.model.releaseFromRead();
            }
        }

        public Set<IResourceModelElement> getContextElements() {
            HashSet<IResourceModelElement> contextElements = new HashSet<IResourceModelElement>();
            contextElements.add(this.rootElement);
            return contextElements;
        }

        public IResourceModelElement getRootElement() {
            return this.rootElement;
        }

        public void init(IResource resource) {
            block5: {
                if (resource instanceof IFile) {
                    this.file = (IFile)resource;
                }
                try {
                    this.model = StructuredModelManager.getModelManager().getExistingModelForRead((Object)resource);
                    if (this.model == null) {
                        this.model = StructuredModelManager.getModelManager().getModelForRead(this.file);
                    }
                    if (this.model != null) {
                        IDOMDocument document = ((DOMModelImpl)this.model).getDocument();
                        this.rootElement = new WebflowState(WebflowModelUtils.getWebflowConfig(this.file));
                        this.rootElement.init((IDOMNode)document.getDocumentElement(), null);
                    }
                }
                catch (Exception exception) {
                    if (this.model == null) break block5;
                    this.model.releaseFromRead();
                }
            }
        }
    }
}

