/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model.validation;

import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.document.DOMModelImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.core.model.validation.AbstractValidationContext;
import org.springframework.ide.eclipse.webflow.core.Activator;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowState;
import org.springframework.ide.eclipse.webflow.core.model.IState;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowConfig;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowProject;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.springframework.util.StringUtils;
import org.w3c.dom.NamedNodeMap;

public class WebflowValidationContext
extends AbstractValidationContext {
    private final IWebflowConfig webflowConfig;
    private boolean isVersion1 = true;

    public WebflowValidationContext(IWebflowState state, IWebflowConfig webflowConfig) {
        super((IResourceModelElement)state, null);
        this.webflowConfig = webflowConfig;
        this.determineVersion();
    }

    public IWebflowConfig getWebflowConfig() {
        return this.webflowConfig;
    }

    public boolean isVersion1() {
        return this.isVersion1;
    }

    private void determineVersion() {
        IStructuredModel model = null;
        try {
            try {
                model = StructuredModelManager.getModelManager().getExistingModelForRead((Object)this.getRootElement().getElementResource());
                if (model == null) {
                    model = StructuredModelManager.getModelManager().getModelForRead((IFile)this.getRootElement().getElementResource());
                }
                if (model != null) {
                    IDOMDocument document = ((DOMModelImpl)model).getDocument();
                    NamedNodeMap attributes = document.getDocumentElement().getAttributes();
                    IDOMAttr schemaLocationNode = (IDOMAttr)attributes.getNamedItemNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                    String content = schemaLocationNode.getValue();
                    this.isVersion1 = content.contains("spring-webflow-1");
                }
            }
            catch (Exception exception) {
                if (model != null) {
                    model.releaseFromRead();
                }
                model = null;
            }
        }
        finally {
            if (model != null) {
                model.releaseFromRead();
            }
            model = null;
        }
    }

    public IState getStateFromParentState(String stateId) {
        if (!this.isVersion1() && stateId != null && stateId.contains("#")) {
            IState state;
            block12: {
                IStructuredModel model = null;
                state = null;
                int i = stateId.lastIndexOf(35);
                String parentFlowId = stateId.substring(0, i);
                String parentStateId = stateId.substring(i + 1);
                IWebflowProject project = Activator.getModel().getProject(this.getRootElement().getElementResource().getProject());
                IWebflowConfig parentConfig = project.getConfig(parentFlowId);
                try {
                    try {
                        model = StructuredModelManager.getModelManager().getExistingModelForRead((Object)parentConfig.getElementResource());
                        if (model == null) {
                            model = StructuredModelManager.getModelManager().getModelForRead((IFile)parentConfig.getElementResource());
                        }
                        if (model != null) {
                            IDOMDocument document = ((DOMModelImpl)model).getDocument();
                            WebflowState parentState = new WebflowState(parentConfig);
                            parentState.init((IDOMNode)document.getDocumentElement(), null);
                            state = WebflowModelXmlUtils.getStateById(parentState, parentStateId);
                        }
                    }
                    catch (Exception exception) {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        model = null;
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    model = null;
                    throw throwable;
                }
                if (model != null) {
                    model.releaseFromRead();
                }
                model = null;
            }
            if (state != null) {
                return state;
            }
        }
        return null;
    }

    public IState getStateFromParentFlow(String stateId, IWebflowConfig config) {
        if (!this.isVersion1()) {
            Iterator iterator;
            String parent;
            IStructuredModel model;
            block22: {
                model = null;
                parent = null;
                try {
                    try {
                        IDOMDocument document;
                        NamedNodeMap attributes;
                        model = StructuredModelManager.getModelManager().getExistingModelForRead((Object)config.getElementResource());
                        if (model == null) {
                            model = StructuredModelManager.getModelManager().getModelForRead((IFile)config.getElementResource());
                        }
                        if (model != null && (attributes = (document = ((DOMModelImpl)model).getDocument()).getDocumentElement().getAttributes()).getNamedItem("parent") != null) {
                            IDOMAttr schemaLocationNode = (IDOMAttr)attributes.getNamedItem("parent");
                            parent = schemaLocationNode.getValue();
                        }
                    }
                    catch (Exception exception) {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        model = null;
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    model = null;
                    throw throwable;
                }
                if (model != null) {
                    model.releaseFromRead();
                }
                model = null;
            }
            if (parent != null && (iterator = StringUtils.commaDelimitedListToSet(parent).iterator()).hasNext()) {
                IWebflowConfig parentConfig;
                IState state;
                block24: {
                    Object p = iterator.next();
                    state = null;
                    IWebflowProject project = Activator.getModel().getProject(this.getRootElement().getElementResource().getProject());
                    parentConfig = project.getConfig((String)p);
                    try {
                        try {
                            model = StructuredModelManager.getModelManager().getExistingModelForRead((Object)parentConfig.getElementResource());
                            if (model == null) {
                                model = StructuredModelManager.getModelManager().getModelForRead((IFile)parentConfig.getElementResource());
                            }
                            if (model != null) {
                                IDOMDocument document = ((DOMModelImpl)model).getDocument();
                                WebflowState parentState = new WebflowState(parentConfig);
                                parentState.init((IDOMNode)document.getDocumentElement(), null);
                                state = WebflowModelXmlUtils.getStateById(parentState, stateId);
                            }
                        }
                        catch (Exception exception) {
                            if (model != null) {
                                model.releaseFromRead();
                            }
                            model = null;
                            break block24;
                        }
                    }
                    catch (Throwable throwable) {
                        if (model != null) {
                            model.releaseFromRead();
                        }
                        model = null;
                        throw throwable;
                    }
                    if (model != null) {
                        model.releaseFromRead();
                    }
                    model = null;
                }
                if (state != null) {
                    return state;
                }
                return this.getStateFromParentFlow(stateId, parentConfig);
            }
        }
        return null;
    }
}

