/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.properties.XMLPropertySource;
import org.springframework.ide.eclipse.beans.ui.editor.util.BeansEditorUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowElementPropertySource;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class WebflowModelElement
implements IWebflowModelElement,
IAdaptable {
    protected IDOMNode node = null;
    protected IWebflowModelElement parent;
    protected transient PropertyChangeSupport listeners = new PropertyChangeSupport(this);

    protected WebflowModelElement() {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.listeners.addPropertyChangeListener(l);
    }

    public void firePropertyChange(String prop, Object old, Object newValue) {
        this.listeners.firePropertyChange(prop, old, newValue);
    }

    public void firePropertyChange(String prop) {
        this.listeners.firePropertyChange(prop, "old", "newValue");
    }

    @Override
    public void fireStructureChange(String prop, Object child) {
        this.listeners.firePropertyChange(prop, null, child);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.listeners.removePropertyChangeListener(l);
    }

    protected String getAttribute(String attributeName) {
        return this.getAttribute(this.node, attributeName);
    }

    public String getAttribute(IDOMNode node, String attributeName) {
        return BeansEditorUtils.getAttribute((Node)node, (String)attributeName);
    }

    protected void setAttribute(String attributeName, String value) {
        this.setAttribute(this.node, attributeName, value);
    }

    protected void setAttribute(IDOMNode node, String attributeName, String value) {
        if (!StringUtils.hasText((String)value)) {
            value = null;
        }
        node.getModel().aboutToChangeModel();
        if (value != null) {
            ((Element)node).setAttribute(attributeName, value);
        } else {
            ((Element)node).removeAttribute(attributeName);
        }
        node.getModel().changedModel();
        this.firePropertyChange("properties", null, value);
    }

    protected List<IDOMNode> getChildrenNodeByTagName(String tagName) {
        NodeList children;
        ArrayList<IDOMNode> nodes = new ArrayList<IDOMNode>();
        if (this.node != null && (children = this.node.getChildNodes()) != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                if (children.item(i).getLocalName() != null && children.item(i).getLocalName().equals(tagName)) {
                    nodes.add((IDOMNode)children.item(i));
                }
                ++i;
            }
        }
        return nodes;
    }

    @Override
    public IDOMNode getNode() {
        return this.node;
    }

    public IModelElement getElementParent() {
        return this.parent;
    }

    @Override
    public void setElementParent(IWebflowModelElement parent) {
        this.parent = parent;
    }

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        this.node = node;
        this.parent = parent;
    }

    public Object getAdapter(Class key) {
        IDOMNode source;
        IPropertySource propertySource;
        if (IPropertySource.class == key && this.node instanceof IDOMNode && (propertySource = (IPropertySource)(source = this.node).getAdapterFor(IPropertySource.class)) == null) {
            propertySource = new XMLPropertySource((INodeNotifier)source);
            return new WebflowElementPropertySource(propertySource);
        }
        return null;
    }

    @Override
    public int getElementStartLine() {
        IStructuredDocument doc;
        if (this.node != null && (doc = this.node.getStructuredDocument()) != null) {
            return doc.getLineOfOffset(this.node.getStartOffset()) + 1;
        }
        return -1;
    }

    public int getElementEndLine() {
        return this.getElementStartLine();
    }

    public IResourceModelElement getElementSourceElement() {
        return null;
    }

    public IModelSourceLocation getElementSourceLocation() {
        return null;
    }
}

