/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IModelElementVisitor;
import org.springframework.ide.eclipse.webflow.core.internal.model.AbstractTransitionableFrom;
import org.springframework.ide.eclipse.webflow.core.internal.model.AttributeMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeMapper;
import org.springframework.ide.eclipse.webflow.core.model.ICloneableModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.model.IInputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IOutputAttribute;
import org.springframework.ide.eclipse.webflow.core.model.ISubflowState;
import org.springframework.ide.eclipse.webflow.core.model.ITransition;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowState;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SubflowState
extends AbstractTransitionableFrom
implements ISubflowState,
ICloneableModelElement<ISubflowState> {
    private IAttributeMapper attributeMapper;
    private List<IInputAttribute> inputAttributes = null;
    private List<IOutputAttribute> outputAttributes = null;

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        super.init(node, parent);
        this.attributeMapper = null;
        this.inputAttributes = new ArrayList<IInputAttribute>();
        this.outputAttributes = new ArrayList<IOutputAttribute>();
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                InputAttribute attr;
                IDOMNode child = (IDOMNode)children.item(i);
                if ("attribute-mapper".equals(child.getLocalName())) {
                    this.attributeMapper = new AttributeMapper();
                    this.attributeMapper.init(child, this);
                } else if ("input".equals(child.getLocalName())) {
                    attr = new InputAttribute();
                    attr.init(child, this);
                    this.inputAttributes.add(attr);
                } else if ("output".equals(child.getLocalName())) {
                    attr = new OutputAttribute();
                    attr.init(child, this);
                    this.outputAttributes.add((IOutputAttribute)((Object)attr));
                }
                ++i;
            }
        }
    }

    @Override
    public IAttributeMapper getAttributeMapper() {
        return this.attributeMapper;
    }

    @Override
    public void setAttributeMapper(IAttributeMapper attributeMapper) {
        IAttributeMapper oldValue = this.attributeMapper;
        if (this.attributeMapper != null) {
            this.getNode().removeChild((Node)this.attributeMapper.getNode());
        }
        this.attributeMapper = attributeMapper;
        if (attributeMapper != null) {
            WebflowModelXmlUtils.insertNode((Node)attributeMapper.getNode(), (Node)this.getNode());
        }
        super.firePropertyChange("add_children", new Integer(0), oldValue);
    }

    @Override
    public void removeAttributeMapper() {
        IAttributeMapper oldValue = this.attributeMapper;
        if (this.attributeMapper != null) {
            this.getNode().removeChild((Node)this.attributeMapper.getNode());
        }
        this.attributeMapper = null;
        super.firePropertyChange("remove_children", this.attributeMapper, oldValue);
    }

    @Override
    public void setFlow(String flow) {
        if (WebflowModelXmlUtils.isVersion1Flow(this)) {
            this.setAttribute("flow", flow);
        } else {
            this.setAttribute("subflow", flow);
        }
    }

    @Override
    public String getFlow() {
        if (WebflowModelXmlUtils.isVersion1Flow(this)) {
            return this.getAttribute("flow");
        }
        return this.getAttribute("subflow");
    }

    @Override
    public void createNew(IWebflowState parent) {
        IDOMNode node = (IDOMNode)parent.getNode().getOwnerDocument().createElement("subflow-state");
        this.init(node, parent);
    }

    @Override
    public ISubflowState cloneModelElement() {
        SubflowState state = new SubflowState();
        state.init((IDOMNode)this.node.cloneNode(true), this.parent);
        return state;
    }

    @Override
    public void applyCloneValues(ISubflowState element) {
        if (element != null) {
            if (this.node.getParentNode() != null) {
                this.parent.getNode().replaceChild((Node)element.getNode(), (Node)this.node);
            }
            this.setId(element.getId());
            this.setFlow(element.getFlow());
            this.init(element.getNode(), this.parent);
            super.fireStructureChange("move_children", new Integer(1));
        }
    }

    public void accept(IModelElementVisitor visitor, IProgressMonitor monitor) {
        if (!monitor.isCanceled() && visitor.visit((IModelElement)this, monitor)) {
            for (IAttribute iAttribute : this.getAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iAttribute.accept(visitor, monitor);
            }
            if (this.getEntryActions() != null) {
                this.getEntryActions().accept(visitor, monitor);
            }
            if (monitor.isCanceled()) {
                return;
            }
            if (this.getAttributeMapper() != null) {
                this.getAttributeMapper().accept(visitor, monitor);
            }
            if (this.getExitActions() != null) {
                this.getExitActions().accept(visitor, monitor);
            }
            for (IInputAttribute iInputAttribute : this.getInputAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iInputAttribute.accept(visitor, monitor);
            }
            for (IOutputAttribute iOutputAttribute : this.getOutputAttributes()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iOutputAttribute.accept(visitor, monitor);
            }
            for (IExceptionHandler iExceptionHandler : this.getExceptionHandlers()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iExceptionHandler.accept(visitor, monitor);
            }
            for (ITransition iTransition : this.getOutputTransitions()) {
                if (monitor.isCanceled()) {
                    return;
                }
                iTransition.accept(visitor, monitor);
            }
        }
    }

    @Override
    public List<IInputAttribute> getInputAttributes() {
        return this.inputAttributes;
    }

    @Override
    public void addInputAttribute(IInputAttribute action) {
        if (!this.inputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.inputAttributes.add(action);
            super.firePropertyChange("add_children", new Integer(this.inputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void addInputAttribute(IInputAttribute action, int i) {
        if (!this.inputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.inputAttributes.add(i, action);
            super.firePropertyChange("add_children", new Integer(this.inputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllInputAttribute() {
        for (IInputAttribute action : this.inputAttributes) {
            this.getNode().removeChild((Node)action.getNode());
        }
        this.inputAttributes = new ArrayList<IInputAttribute>();
    }

    @Override
    public void removeInputAttribute(IInputAttribute action) {
        if (this.inputAttributes.contains(action)) {
            this.inputAttributes.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    @Override
    public List<IOutputAttribute> getOutputAttributes() {
        return this.outputAttributes;
    }

    @Override
    public void addOutputAttribute(IOutputAttribute action) {
        if (!this.outputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.outputAttributes.add(action);
            super.firePropertyChange("add_children", new Integer(this.outputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void addOutputAttribute(IOutputAttribute action, int i) {
        if (!this.outputAttributes.contains(action)) {
            WebflowModelXmlUtils.insertNode((Node)action.getNode(), (Node)this.node);
            this.outputAttributes.add(i, action);
            super.firePropertyChange("add_children", new Integer(this.outputAttributes.indexOf(action)), action);
        }
    }

    @Override
    public void removeAllOutputAttribute() {
        for (IInputAttribute iInputAttribute : this.outputAttributes) {
            this.getNode().removeChild((Node)iInputAttribute.getNode());
        }
        this.outputAttributes = new ArrayList<IOutputAttribute>();
    }

    @Override
    public void removeOutputAttribute(IOutputAttribute action) {
        if (this.outputAttributes.contains(action)) {
            this.outputAttributes.remove(action);
            this.getNode().removeChild((Node)action.getNode());
            super.fireStructureChange("remove_children", action);
        }
    }

    public IModelElement[] getElementChildren() {
        ArrayList<IWebflowModelElement> children = new ArrayList<IWebflowModelElement>();
        children.addAll(this.getAttributes());
        children.add(this.getEntryActions());
        children.add(this.getAttributeMapper());
        children.addAll(this.getInputAttributes());
        children.addAll(this.getOutputAttributes());
        children.add(this.getExitActions());
        children.addAll(this.getExceptionHandlers());
        children.addAll(this.getOutputTransitions());
        return children.toArray(new IModelElement[children.size()]);
    }

    @Override
    public String getSubflowAttributeMapper() {
        return this.getAttribute("subflow-attribute-mapper");
    }

    @Override
    public void setSubflowAttributeMapper(String bean) {
        this.setAttribute("subflow-attribute-mapper", bean);
    }
}

