/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.webflow.core.internal.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.core.model.IModelElement;
import org.springframework.ide.eclipse.core.model.IResourceModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.Action;
import org.springframework.ide.eclipse.webflow.core.internal.model.ActionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.Argument;
import org.springframework.ide.eclipse.webflow.core.internal.model.Attribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.AttributeMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.BeanAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.DecisionState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EndState;
import org.springframework.ide.eclipse.webflow.core.internal.model.EntryActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluateAction;
import org.springframework.ide.eclipse.webflow.core.internal.model.EvaluationResult;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExceptionHandler;
import org.springframework.ide.eclipse.webflow.core.internal.model.ExitActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.GlobalTransitions;
import org.springframework.ide.eclipse.webflow.core.internal.model.If;
import org.springframework.ide.eclipse.webflow.core.internal.model.IfTransition;
import org.springframework.ide.eclipse.webflow.core.internal.model.Import;
import org.springframework.ide.eclipse.webflow.core.internal.model.InlineFlowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.InputMapper;
import org.springframework.ide.eclipse.webflow.core.internal.model.Mapping;
import org.springframework.ide.eclipse.webflow.core.internal.model.MethodArguments;
import org.springframework.ide.eclipse.webflow.core.internal.model.MethodResult;
import org.springframework.ide.eclipse.webflow.core.internal.model.OutputAttribute;
import org.springframework.ide.eclipse.webflow.core.internal.model.RenderActions;
import org.springframework.ide.eclipse.webflow.core.internal.model.Set;
import org.springframework.ide.eclipse.webflow.core.internal.model.StateTransition;
import org.springframework.ide.eclipse.webflow.core.internal.model.SubflowState;
import org.springframework.ide.eclipse.webflow.core.internal.model.Variable;
import org.springframework.ide.eclipse.webflow.core.internal.model.ViewState;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowConfig;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModel;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelElement;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowModelXmlUtils;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowProject;
import org.springframework.ide.eclipse.webflow.core.internal.model.WebflowState;
import org.springframework.ide.eclipse.webflow.core.model.IAttribute;
import org.springframework.ide.eclipse.webflow.core.model.IAttributeEnabled;
import org.springframework.ide.eclipse.webflow.core.model.IWebflowModelElement;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractModelElement
extends WebflowModelElement
implements IAttributeEnabled {
    private static final Map<Class, Integer> ELEMENT_TYPE_MAPPING = new HashMap<Class, Integer>();
    protected List<IAttribute> attributes;
    char ID_DELIMITER = (char)124;
    char ID_SEPARATOR = (char)58;

    static {
        ELEMENT_TYPE_MAPPING.put(WebflowModel.class, 1);
        ELEMENT_TYPE_MAPPING.put(WebflowProject.class, 2);
        ELEMENT_TYPE_MAPPING.put(WebflowConfig.class, 3);
        ELEMENT_TYPE_MAPPING.put(WebflowState.class, 4);
        ELEMENT_TYPE_MAPPING.put(Action.class, 5);
        ELEMENT_TYPE_MAPPING.put(ActionState.class, 6);
        ELEMENT_TYPE_MAPPING.put(Argument.class, 7);
        ELEMENT_TYPE_MAPPING.put(Attribute.class, 8);
        ELEMENT_TYPE_MAPPING.put(AttributeMapper.class, 9);
        ELEMENT_TYPE_MAPPING.put(BeanAction.class, 10);
        ELEMENT_TYPE_MAPPING.put(DecisionState.class, 11);
        ELEMENT_TYPE_MAPPING.put(EndState.class, 12);
        ELEMENT_TYPE_MAPPING.put(EntryActions.class, 13);
        ELEMENT_TYPE_MAPPING.put(EvaluateAction.class, 14);
        ELEMENT_TYPE_MAPPING.put(EvaluationResult.class, 15);
        ELEMENT_TYPE_MAPPING.put(ExceptionHandler.class, 16);
        ELEMENT_TYPE_MAPPING.put(ExitActions.class, 17);
        ELEMENT_TYPE_MAPPING.put(GlobalTransitions.class, 18);
        ELEMENT_TYPE_MAPPING.put(If.class, 19);
        ELEMENT_TYPE_MAPPING.put(IfTransition.class, 20);
        ELEMENT_TYPE_MAPPING.put(Import.class, 21);
        ELEMENT_TYPE_MAPPING.put(InlineFlowState.class, 22);
        ELEMENT_TYPE_MAPPING.put(InputAttribute.class, 23);
        ELEMENT_TYPE_MAPPING.put(InputMapper.class, 34);
        ELEMENT_TYPE_MAPPING.put(Mapping.class, 25);
        ELEMENT_TYPE_MAPPING.put(MethodArguments.class, 26);
        ELEMENT_TYPE_MAPPING.put(MethodResult.class, 27);
        ELEMENT_TYPE_MAPPING.put(OutputAttribute.class, 28);
        ELEMENT_TYPE_MAPPING.put(RenderActions.class, 29);
        ELEMENT_TYPE_MAPPING.put(Set.class, 30);
        ELEMENT_TYPE_MAPPING.put(StateTransition.class, 31);
        ELEMENT_TYPE_MAPPING.put(SubflowState.class, 32);
        ELEMENT_TYPE_MAPPING.put(Variable.class, 33);
        ELEMENT_TYPE_MAPPING.put(ViewState.class, 34);
    }

    @Override
    public void init(IDOMNode node, IWebflowModelElement parent) {
        NodeList children;
        super.init(node, parent);
        this.attributes = new ArrayList<IAttribute>();
        if (node != null && (children = node.getChildNodes()) != null && children.getLength() > 0) {
            int i = 0;
            while (i < children.getLength()) {
                IDOMNode child = (IDOMNode)children.item(i);
                if ("attribute".equals(child.getLocalName())) {
                    Attribute p = new Attribute();
                    p.init(child, this);
                    this.attributes.add(p);
                }
                ++i;
            }
        }
    }

    @Override
    public void addAttribute(IAttribute property) {
        if (!this.attributes.contains(property)) {
            WebflowModelXmlUtils.insertNode((Node)property.getNode(), (Node)this.getNode());
            this.attributes.add(property);
            super.firePropertyChange("add_children", new Integer(this.attributes.indexOf(property)), property);
        }
    }

    @Override
    public void addAttribute(IAttribute property, int index) {
        if (!this.attributes.contains(property)) {
            this.attributes.add(index, property);
            WebflowModelXmlUtils.determineNodeToInsert((Node)property.getNode(), (Node)this.getNode());
            super.firePropertyChange("add_children", new Integer(index), property);
        }
    }

    @Override
    public List<IAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public void removeAttribute(IAttribute property) {
        if (this.attributes.contains(property)) {
            this.attributes.remove(property);
            this.getNode().removeChild((Node)property.getNode());
            super.fireStructureChange("remove_children", property);
        }
    }

    public void addProperty(String name, String value) {
    }

    public final String getElementID() {
        StringBuffer id = new StringBuffer();
        if (this.getElementParent() != null) {
            id.append(this.getElementParent().getElementID());
            id.append(this.ID_DELIMITER);
        }
        id.append(this.getElementType());
        id.append(this.ID_SEPARATOR);
        if (this.getElementName() != null) {
            id.append(this.getElementName());
        } else {
            id.append(super.hashCode());
        }
        return id.toString();
    }

    public IModelElement getElement(String id) {
        int sepPos = id.indexOf(this.ID_SEPARATOR);
        if (sepPos > 0) {
            try {
                int type = Integer.valueOf(id.substring(0, sepPos));
                if (type == this.getElementType()) {
                    int delPos = id.indexOf(this.ID_DELIMITER);
                    if (delPos > 0) {
                        String name = id.substring(sepPos + 1, delPos);
                        if (name.equals(this.getElementName())) {
                            id = id.substring(delPos + 1);
                            IModelElement[] iModelElementArray = this.getElementChildren();
                            int n = iModelElementArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IModelElement element;
                                IModelElement child = iModelElementArray[n2];
                                if (child instanceof AbstractModelElement && (element = ((AbstractModelElement)child).getElement(id)) != null) {
                                    return element;
                                }
                                ++n2;
                            }
                        }
                    } else {
                        String name = id.substring(sepPos + 1);
                        if (name.equals(this.getElementName())) {
                            return this;
                        }
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return null;
    }

    public int getElementType() {
        return ELEMENT_TYPE_MAPPING.get(this.getClass());
    }

    public String getElementName() {
        return String.valueOf(ClassUtils.getShortName(this.getClass())) + " (" + this.getElementStartLine() + ")";
    }

    public IResource getElementResource() {
        IResource resource = null;
        IResourceModelElement parent = (IResourceModelElement)this.getElementParent();
        while (resource == null && parent != null) {
            resource = parent.getElementResource();
            parent = (IResourceModelElement)this.getElementParent();
        }
        return resource;
    }

    public boolean isElementArchived() {
        return false;
    }

    public boolean isExternal() {
        return false;
    }
}

