/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.metadata.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.ide.eclipse.beans.core.metadata.model.AbstractMethodAnnotationMetadata;
import org.springframework.ide.eclipse.core.java.annotation.AnnotationMemberValuePair;
import org.springframework.ide.eclipse.core.model.IModelSourceLocation;

public class BeanMethodAnnotationMetadata
extends AbstractMethodAnnotationMetadata {
    private static final long serialVersionUID = 4590913995747027452L;

    public BeanMethodAnnotationMetadata(String key, String handle, Object value, IModelSourceLocation location) {
        super(key, handle, value, location);
    }

    public String getValueAsText() {
        StringBuilder buf = new StringBuilder();
        IJavaElement je = JavaCore.create((String)this.getHandleIdentifier());
        if (this.getValue() instanceof Set) {
            HashSet pairs = new HashSet((Set)this.getValue());
            for (AnnotationMemberValuePair pair : (Set)this.getValue()) {
                if (!"name".equals(pair.getName())) continue;
                buf.append(pair.getValue());
                pairs.remove(pair);
            }
            if (buf.length() == 0) {
                buf.append(je.getElementName());
            }
            if (pairs.size() > 0) {
                buf.append(" (");
            }
            for (AnnotationMemberValuePair pair : pairs) {
                if (pair.getName() != null) {
                    buf.append(pair.getName());
                    buf.append(" = ");
                }
                buf.append(pair.getValue());
                buf.append(", ");
            }
            if (pairs.size() > 0) {
                buf = new StringBuilder(buf.substring(0, buf.length() - 2));
                buf.append(")");
            }
            return buf.append(" - ").toString();
        }
        return "";
    }
}

