/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.config.graph.parts;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.graph.CompoundDirectedGraph;
import org.eclipse.draw2d.graph.Edge;
import org.eclipse.draw2d.graph.EdgeList;
import org.eclipse.draw2d.graph.Node;
import org.eclipse.draw2d.graph.NodeList;
import org.eclipse.draw2d.graph.Subgraph;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.springframework.ide.eclipse.config.graph.figures.TransitionLabel;
import org.springframework.ide.eclipse.config.graph.model.LabelledTransition;
import org.springframework.ide.eclipse.config.graph.parts.TransitionPart;

public class LabelledTransitionPart
extends TransitionPart {
    private Label l;

    public LabelledTransitionPart(LabelledTransition model) {
        super(model);
    }

    @Override
    protected void applyGraphResults(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        if (!this.isManualLayout()) {
            Node n = (Node)map.get(this);
            ArrayList bends = new ArrayList();
            this.applyBends(bends, n.incoming);
            this.applyBends(bends, n.outgoing);
            this.getConnectionFigure().setRoutingConstraint(bends);
        }
    }

    protected void applyBends(List bends, EdgeList edges) {
        int i = 0;
        while (i < edges.size()) {
            Edge e = (Edge)edges.get(i);
            NodeList nodes = e.vNodes;
            if (nodes != null) {
                int j = 0;
                while (j < nodes.size()) {
                    Node vn = nodes.getNode(i);
                    int x = vn.x;
                    int y = vn.y;
                    if (e.isFeedback()) {
                        bends.add(new AbsoluteBendpoint(x, y + vn.height));
                        bends.add(new AbsoluteBendpoint(x, y));
                    } else {
                        bends.add(new AbsoluteBendpoint(x, y));
                        bends.add(new AbsoluteBendpoint(x, y + vn.height));
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    @Override
    public void contributeNodesToGraph(CompoundDirectedGraph graph, Subgraph s, Map<AbstractGraphicalEditPart, Object> map) {
        Node n = new Node((Object)this, s);
        Dimension hint = this.getConnectionFigure().getPreferredSize();
        n.width = hint.width;
        n.height = hint.height;
        if (graph.getDirection() == 16) {
            n.setPadding(new Insets(8, 10, 12, 10));
        } else {
            n.setPadding(new Insets(10, 8, 10, 12));
        }
        map.put((AbstractGraphicalEditPart)this, n);
        graph.nodes.add((Object)n);
    }

    @Override
    public void contributeToGraph(CompoundDirectedGraph graph, Map<AbstractGraphicalEditPart, Object> map) {
        Node source = (Node)map.get(this.getSource());
        Node target = (Node)map.get(this.getTarget());
        Node n = (Node)map.get(this);
        graph.edges.add((Object)new Edge(source, n));
        graph.edges.add((Object)new Edge(n, target));
    }

    @Override
    protected IFigure createFigure() {
        PolylineConnection conn = (PolylineConnection)super.createFigure();
        this.l = new TransitionLabel(75);
        this.l.setForegroundColor(ColorConstants.black);
        this.l.setOpaque(true);
        conn.add((IFigure)this.l, (Object)new ConnectionLocator((Connection)conn));
        return conn;
    }

    protected void refreshFigureVisuals() {
        if (this.l != null) {
            this.l.setText(((LabelledTransition)this.getModel()).getLabel());
        }
    }

    protected void refreshTooltipVisuals() {
        if (this.l != null) {
            Label tooltip = (Label)this.l.getToolTip();
            if (tooltip == null) {
                tooltip = new Label();
                this.l.setToolTip((IFigure)tooltip);
            }
            tooltip.setText(((LabelledTransition)this.getModel()).getLabel());
        }
    }

    protected void refreshVisuals() {
        this.refreshFigureVisuals();
        this.refreshTooltipVisuals();
    }
}

