/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.ui.viewers;

import java.util.Collection;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.springframework.ide.eclipse.ui.SpringUIPlugin;

public class FileSuffixFilter
extends ViewerFilter {
    private String[] allowedFileSuffixes;

    public FileSuffixFilter(String[] allowedFileSuffixes) {
        this.allowedFileSuffixes = allowedFileSuffixes;
    }

    public FileSuffixFilter(Collection<String> allowedFileSuffixes) {
        this(allowedFileSuffixes.toArray(new String[allowedFileSuffixes.size()]));
    }

    public FileSuffixFilter() {
        this.allowedFileSuffixes = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean select(Viewer viewer, Object parent, Object element) {
        if (element instanceof IFile) {
            if (!this.hasAllowedFileSuffix(((IFile)element).getFullPath())) return false;
            if (!this.selectFile((IFile)element)) return false;
            return true;
        }
        if (!(element instanceof IContainer)) return false;
        try {
            if (".settings".equals(((IContainer)element).getName())) return false;
            IResource[] iResourceArray = ((IContainer)element).members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IResource resource = iResourceArray[n2];
                if (this.select(viewer, parent, resource)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            SpringUIPlugin.log(e.getStatus());
        }
        return false;
    }

    protected boolean selectFile(IFile element) {
        return true;
    }

    protected boolean hasAllowedFileSuffix(IPath path) {
        if (this.allowedFileSuffixes == null) {
            return true;
        }
        String fileName = path.lastSegment();
        if (fileName != null) {
            String[] stringArray = this.allowedFileSuffixes;
            int n = this.allowedFileSuffixes.length;
            int n2 = 0;
            while (n2 < n) {
                String allowedSuffix = stringArray[n2];
                if (fileName.endsWith(allowedSuffix)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

