/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.security.core.aop.model.builder;

import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.springframework.ide.eclipse.aop.core.internal.model.JavaAdvisorDefinition;
import org.springframework.ide.eclipse.aop.core.internal.model.builder.AbstractAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.logging.AopLog;
import org.springframework.ide.eclipse.aop.core.model.IAopReference;
import org.springframework.ide.eclipse.aop.core.model.IAspectDefinition;
import org.springframework.ide.eclipse.aop.core.model.builder.IAspectDefinitionBuilder;
import org.springframework.ide.eclipse.aop.core.model.builder.IDocumentFactory;
import org.springframework.ide.eclipse.core.java.IProjectClassLoaderSupport;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SecurityXmlAspectDefinitionBuilder
extends AbstractAspectDefinitionBuilder
implements IAspectDefinitionBuilder {
    private static final String EXPRESSION_ATTRIBUTE = "expression";
    private static final String GLOBAL_METHOD_SECURITY_ELEMENT = "global-method-security";
    private static final String JSR250_ANNOTATION_EXPRESSION = "(@within(javax.annotation.security.DenyAll) || @annotation(javax.annotation.security.DenyAll) || @within(javax.annotation.security.PermitAll) || @annotation(javax.annotation.security.PermitAll) || @within(javax.annotation.security.RolesAllowed) || @annotation(javax.annotation.security.RolesAllowed)) && execution(* *..*(..))";
    private static final String METHOD_SECURITY_INTERCEPTOR_BEAN_ID = "_methodSecurityInterceptor";
    private static final String METHOD_SECURITY_INTERCEPTOR_V2_CLASS = "org.springframework.security.intercept.method.aopalliance.MethodSecurityInterceptor";
    private static final String METHOD_SECURITY_INTERCEPTOR_V3_CLASS = "org.springframework.security.access.intercept.aopalliance.MethodSecurityInterceptor";
    private static final String PROTECT_POINTCUT_ELEMENT = "protect-pointcut";
    private static final String SECURED_ANNOTATION_EXPRESSION = "(@within($CLASS) || @annotation($CLASS)) && execution(* *..*(..))";
    private static final String SECURED_ANNOTATION_V2_CLASS = "org.springframework.security.annotation.Secured";
    private static final String SECURED_ANNOTATION_V3_CLASS = "org.springframework.security.access.annotation.Secured";
    private static final String SECURITY_NAMESPACE_URI = "http://www.springframework.org/schema/security";

    public void buildAspectDefinitions(List<IAspectDefinition> aspectInfos, IFile file, IProjectClassLoaderSupport classLoaderSupport, IDocumentFactory factory) {
        if (file.getFileExtension() != null && file.getFileExtension().equals("xml")) {
            this.parseGlobalMethodSecurityElement(factory.createDocument(file), file, aspectInfos, classLoaderSupport);
        }
    }

    private void addAspectDefinition(IAspectDefinition info, List<IAspectDefinition> aspectInfos) {
        AopLog.log((int)4, (String)info.toString());
        aspectInfos.add(info);
    }

    private void parseGlobalMethodSecurityElement(IDOMDocument document, IFile file, List<IAspectDefinition> aspectInfos, IProjectClassLoaderSupport classLoaderSupport) {
        if (document == null || document.getStructuredDocument() == null) {
            return;
        }
        NodeList list = document.getDocumentElement().getElementsByTagNameNS(SECURITY_NAMESPACE_URI, GLOBAL_METHOD_SECURITY_ELEMENT);
        if (list.getLength() == 0) {
            return;
        }
        boolean present20 = ClassUtils.isPresent((String)METHOD_SECURITY_INTERCEPTOR_V2_CLASS, (ClassLoader)classLoaderSupport.getProjectClassLoader());
        boolean present30 = ClassUtils.isPresent((String)METHOD_SECURITY_INTERCEPTOR_V3_CLASS, (ClassLoader)classLoaderSupport.getProjectClassLoader());
        if (present30 && present20) {
            return;
        }
        if (!present20 && !present30) {
            return;
        }
        int i = 0;
        while (i < list.getLength()) {
            ArrayList<IAspectDefinition> aspectDefinitions = new ArrayList<IAspectDefinition>();
            Node node = list.item(i);
            String securedAnnotations = this.getAttribute(node, "secured-annotations");
            String jsr250Annoatations = this.getAttribute(node, "jsr250-annotations");
            if ("enabled".equals(securedAnnotations)) {
                this.createAnnotationInfo(file, aspectInfos, node, SECURED_ANNOTATION_EXPRESSION.replace("$CLASS", present30 ? SECURED_ANNOTATION_V3_CLASS : SECURED_ANNOTATION_V2_CLASS), present30);
            }
            if ("enabled".equals(jsr250Annoatations)) {
                boolean presentDenyAll = ClassUtils.isPresent((String)"javax.annotation.security.DenyAll", (ClassLoader)classLoaderSupport.getProjectClassLoader());
                boolean presentPermitAll = ClassUtils.isPresent((String)"javax.annotation.security.PermitAll", (ClassLoader)classLoaderSupport.getProjectClassLoader());
                boolean presentRolesAllowed = ClassUtils.isPresent((String)"javax.annotation.security.RolesAllowed", (ClassLoader)classLoaderSupport.getProjectClassLoader());
                if (presentDenyAll && presentPermitAll && presentRolesAllowed) {
                    this.createAnnotationInfo(file, aspectInfos, node, JSR250_ANNOTATION_EXPRESSION, present30);
                }
            }
            NodeList children = node.getChildNodes();
            int j = 0;
            while (j < children.getLength()) {
                Node child = children.item(j);
                if (PROTECT_POINTCUT_ELEMENT.equals(child.getLocalName())) {
                    this.parseProtectPointcutElement(file, child, aspectDefinitions, present30);
                }
                ++j;
            }
            aspectInfos.addAll(aspectDefinitions);
            ++i;
        }
    }

    private void createAnnotationInfo(IFile file, List<IAspectDefinition> aspectInfos, Node node, String expression, boolean present30) {
        JavaAdvisorDefinition info1 = this.prepareJavaAdvisorDefinition(file, node, expression, present30);
        info1.setProxyTargetClass(true);
        this.addAspectDefinition((IAspectDefinition)info1, aspectInfos);
        JavaAdvisorDefinition info2 = this.prepareJavaAdvisorDefinition(file, node, expression, present30);
        info2.setProxyTargetClass(false);
        this.addAspectDefinition((IAspectDefinition)info2, aspectInfos);
    }

    private void parseProtectPointcutElement(IFile file, Node protectPointcutNode, List<IAspectDefinition> aspectInfos, boolean present30) {
        String pointcutExpression = this.getAttribute(protectPointcutNode, EXPRESSION_ATTRIBUTE);
        if (StringUtils.hasText((String)pointcutExpression)) {
            JavaAdvisorDefinition info = this.prepareJavaAdvisorDefinition(file, protectPointcutNode, pointcutExpression, present30);
            this.addAspectDefinition((IAspectDefinition)info, aspectInfos);
        }
    }

    private JavaAdvisorDefinition prepareJavaAdvisorDefinition(IFile file, Node aspectNode, String pointcutExpression, boolean present30) {
        JavaAdvisorDefinition info = new JavaAdvisorDefinition();
        this.extractLineNumbers((IAspectDefinition)info, (IDOMNode)aspectNode);
        info.setPointcutExpression(pointcutExpression);
        info.setAspectClassName(present30 ? METHOD_SECURITY_INTERCEPTOR_V3_CLASS : METHOD_SECURITY_INTERCEPTOR_V2_CLASS);
        info.setAspectName(METHOD_SECURITY_INTERCEPTOR_BEAN_ID);
        info.setType(IAopReference.ADVICE_TYPE.AROUND);
        info.setAdviceMethodName("invoke");
        info.setAdviceMethodParameterTypes(new String[]{MethodInvocation.class.getName()});
        info.setResource((IResource)file);
        return info;
    }
}

