/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.views;

import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestCaseElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.model.TestElement;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.OpenEditorAction;
import com.atlassian.connector.eclipse.internal.bamboo.ui.views.TestResultsView;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.JavaConventionsUtil;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.ITextEditor;

public class OpenTestAction
extends OpenEditorAction {
    private final String fMethodName;
    private IMethod fMethod;
    private int fLineNumber = -1;

    public OpenTestAction(TestResultsView testRunnerPart, TestCaseElement testCase) {
        this(testRunnerPart, testCase.getClassName(), OpenTestAction.extractRealMethodName(testCase.getTestMethodName()), true);
        String trace = testCase.getTrace();
        if (trace != null) {
            String rawClassName = TestElement.extractRawClassName(testCase.getTestName());
            rawClassName = rawClassName.replaceAll("\\.", "\\\\.");
            Pattern pattern = Pattern.compile("at " + (rawClassName = rawClassName.replaceAll("\\$", "\\\\\\$")) + '.' + this.fMethodName + "\\(.*:(\\d+)\\)");
            Matcher matcher = pattern.matcher(trace);
            if (matcher.find()) {
                try {
                    this.fLineNumber = Integer.parseInt(matcher.group(1));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public OpenTestAction(TestResultsView testRunner, String className) {
        this(testRunner, className, null, true);
    }

    private OpenTestAction(TestResultsView testRunner, String className, String method, boolean activate) {
        super(testRunner, className, activate);
        this.fMethodName = method;
    }

    private static String extractRealMethodName(String testMethodName) {
        int i = 0;
        while (i < testMethodName.length()) {
            if (!Character.isJavaIdentifierPart(testMethodName.charAt(i))) {
                return testMethodName.substring(0, i);
            }
            ++i;
        }
        return testMethodName;
    }

    public IJavaElement findElement(String className) throws JavaModelException {
        IType type = this.findType(className);
        if (type == null) {
            return null;
        }
        if (this.fMethodName == null) {
            return type;
        }
        IMethod method = this.findMethod(type);
        if (method == null) {
            IType[] types;
            ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
            IType[] iTypeArray = types = typeHierarchy.getAllSuperclasses(type);
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type2 = iTypeArray[n2];
                method = this.findMethod(type2);
                if (method != null) break;
                ++n2;
            }
        }
        if (method == null) {
            String title = "Go To Test";
            String message = NLS.bind((String)"Method '{0}' not found. Opening the test class.", (Object)BasicElementLabels.getJavaElementName((String)this.fMethodName));
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)message);
            return type;
        }
        this.fMethod = method;
        return method;
    }

    private IMethod findMethod(IType type) {
        IStatus status = JavaConventionsUtil.validateMethodName((String)this.fMethodName, (IJavaElement)type);
        if (!status.isOK()) {
            return null;
        }
        IMethod method = type.getMethod(this.fMethodName, new String[0]);
        if (method != null && method.exists()) {
            return method;
        }
        return null;
    }

    public void reveal(ITextEditor textEditor) {
        if (this.fLineNumber >= 0) {
            try {
                IDocument document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput());
                int lineOffset = document.getLineOffset(this.fLineNumber - 1);
                int lineLength = document.getLineLength(this.fLineNumber - 1);
                if (this.fMethod != null) {
                    try {
                        ISourceRange sr = this.fMethod.getSourceRange();
                        if (sr == null || sr.getOffset() == -1 || lineOffset < sr.getOffset() || sr.getOffset() + sr.getLength() < lineOffset + lineLength) {
                            throw new BadLocationException();
                        }
                    }
                    catch (JavaModelException javaModelException) {}
                }
                textEditor.selectAndReveal(lineOffset, lineLength);
                return;
            }
            catch (BadLocationException badLocationException) {}
        }
        if (this.fMethod != null) {
            try {
                ISourceRange range = this.fMethod.getNameRange();
                if (range != null && range.getOffset() >= 0) {
                    textEditor.selectAndReveal(range.getOffset(), range.getLength());
                }
            }
            catch (JavaModelException javaModelException) {}
        }
    }
}

