/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.connector.eclipse.internal.bamboo.ui.notifications;

import com.atlassian.connector.eclipse.internal.bamboo.core.BambooUtil;
import com.atlassian.connector.eclipse.internal.bamboo.ui.BambooImages;
import com.atlassian.theplugin.commons.bamboo.BambooBuild;
import java.util.Date;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.notifications.ui.AbstractUiNotification;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class BambooNotification
extends AbstractUiNotification {
    private final BambooBuild build;
    private final CHANGE change;
    private final TaskRepository repository;
    private static final String EVENT_ID = "id";

    public BambooNotification(BambooBuild build, TaskRepository repository, CHANGE change) {
        super(EVENT_ID);
        this.build = build;
        this.change = change;
        this.repository = repository;
    }

    public Date getDate() {
        return this.build.getCompletionDate();
    }

    public String getDescription() {
        return this.change.getText();
    }

    public String getLabel() {
        return String.valueOf(this.build.getPlanKey()) + NLS.bind((String)" [{0}]", (Object)this.repository.getRepositoryLabel());
    }

    public Image getNotificationImage() {
        return null;
    }

    public Image getNotificationKindImage() {
        switch (this.build.getStatus()) {
            case FAILURE: {
                return CommonImages.getImage((ImageDescriptor)BambooImages.STATUS_FAILED);
            }
            case SUCCESS: {
                return CommonImages.getImage((ImageDescriptor)BambooImages.STATUS_PASSED);
            }
        }
        return CommonImages.getImage((ImageDescriptor)BambooImages.STATUS_DISABLED);
    }

    public void open() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                String url = BambooUtil.getUrlFromBuild((BambooBuild)BambooNotification.this.build);
                TasksUiUtil.openUrl((String)url);
            }
        });
    }

    public int compareTo(AbstractUiNotification anotherNotification) {
        if (anotherNotification == null) {
            throw new ClassCastException("A BambooNotification object expected.");
        }
        Date date = anotherNotification instanceof BambooNotification ? ((BambooNotification)anotherNotification).getBuild().getCompletionDate() : anotherNotification.getDate();
        if (this.build.getCompletionDate() != null && date != null) {
            return this.build.getCompletionDate().compareTo(date);
        }
        if (this.build.getCompletionDate() == null) {
            return -1;
        }
        return 1;
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public BambooBuild getBuild() {
        return this.build;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CHANGE {
        ADDED("Build added"),
        REMOVED("Build removed"),
        CHANGED("Build changed");

        private final String txt;

        private CHANGE(String txt) {
            this.txt = txt;
        }

        public String getText() {
            return this.txt;
        }
    }
}

