/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.cli.install;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.cli.install.IBootInstall;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;

public abstract class BootInstall
implements IBootInstall {
    private static final File[] NO_FILES = new File[0];
    protected final String uriString;
    static final FilenameFilter JAR_FILE_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().endsWith(".jar");
        }
    };
    private static final String UNKNOWN_VERSION = "Unknown";
    File[] bootLibJars;
    private String name;

    public BootInstall(String urlString, String name) {
        Assert.isNotNull((Object)urlString);
        if (name != null && !"".equals(name.trim())) {
            this.name = name;
        }
        this.uriString = urlString;
    }

    @Override
    public abstract File getHome() throws Exception;

    @Override
    public File[] getBootLibJars() throws Exception {
        if (this.bootLibJars == null) {
            File home = this.getHome();
            this.bootLibJars = new File(home, "lib").listFiles(JAR_FILE_FILTER);
            if (this.bootLibJars == null) {
                this.bootLibJars = NO_FILES;
            }
        }
        return this.bootLibJars;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.uriString == null ? 0 : this.uriString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BootInstall other = (BootInstall)obj;
        return !(this.uriString == null ? other.uriString != null : !this.uriString.equals(other.uriString));
    }

    @Override
    public String getUrl() {
        return this.uriString;
    }

    @Override
    public String getName() {
        if (this.name == null) {
            this.name = this.defaultName();
        }
        return this.name;
    }

    protected String defaultName() {
        String version = this.getVersion();
        if (version != null && !version.equals(UNKNOWN_VERSION)) {
            return "Boot " + version;
        }
        String lastSegment = this.lastSegment();
        if (lastSegment != null) {
            return lastSegment;
        }
        return "Boot";
    }

    public String lastSegment() {
        try {
            URI uri = new URI(this.uriString);
            String lastSegment = new Path(uri.getPath()).lastSegment();
            return lastSegment;
        }
        catch (Exception e) {
            BootActivator.log(e);
            return null;
        }
    }

    @Override
    public String getVersion() {
        String lastSegment = this.lastSegment();
        if (lastSegment != null && lastSegment.toLowerCase().endsWith(".zip")) {
            int start;
            int end = lastSegment.length() - 4;
            if ((end = lastSegment.lastIndexOf(45, end)) >= 0 && (start = lastSegment.lastIndexOf(45, end - 1)) >= 0) {
                return lastSegment.substring(start + 1, end);
            }
        }
        return UNKNOWN_VERSION;
    }

    @Override
    public IStatus validate() {
        try {
            if (this.mayRequireDownload()) {
                return Status.OK_STATUS;
            }
            File[] jars = this.getBootLibJars();
            if (jars == null || jars.length == 0) {
                return new Status(4, "org.springframework.ide.eclipse.boot", "No boot install found at: " + this.getUrl());
            }
            File[] fileArray = jars;
            int n = jars.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.getName().startsWith("spring-boot-cli")) {
                    return Status.OK_STATUS;
                }
                ++n2;
            }
            return new Status(4, "org.springframework.ide.eclipse.boot", "spring-boot-cli jar not found in " + this.getUrl());
        }
        catch (Exception e) {
            BootActivator.log(e);
            return ExceptionUtil.status((Throwable)e);
        }
    }

    protected boolean mayRequireDownload() {
        String url = this.getUrl();
        boolean isCertainlyLocal = url != null && url.startsWith("file:");
        return !isCertainlyLocal;
    }
}

