/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.internal.MavenSpringBootProject;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;
import org.springsource.ide.eclipse.commons.frameworks.core.ExceptionUtil;

public class SpringBootCore {
    public static final String M2E_NATURE = "org.eclipse.m2e.core.maven2Nature";
    private static final StsProperties stsProps = StsProperties.getInstance();

    public static ISpringBootProject create(IProject project) throws CoreException {
        if (project.hasNature(M2E_NATURE)) {
            return new MavenSpringBootProject(project);
        }
        throw ExceptionUtil.coreException((String)"This feature is only implemented for m2e enabled maven projects");
    }

    public static ISpringBootProject create(IJavaProject project) throws CoreException {
        return SpringBootCore.create(project.getProject());
    }

    public static String getDefaultBootVersion() {
        return stsProps.get("spring.boot.default.version");
    }
}

