/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.IReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesReconcileEngine;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.properties.editor.util.SpringPropertyIndexProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtilProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.YamlASTProvider;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.ast.YamlFileAST;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.IndexNavigator;
import org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile.YamlASTReconciler;
import org.yaml.snakeyaml.error.Mark;
import org.yaml.snakeyaml.parser.ParserException;
import org.yaml.snakeyaml.scanner.ScannerException;

public class SpringYamlReconcileEngine
implements IReconcileEngine {
    private YamlASTProvider parser;
    private SpringPropertyIndexProvider indexProvider;
    private TypeUtilProvider typeUtilProvider;

    public SpringYamlReconcileEngine(YamlASTProvider astProvider, SpringPropertyIndexProvider indexProvider, TypeUtilProvider typeUtilProvider) {
        this.parser = astProvider;
        this.indexProvider = indexProvider;
        this.typeUtilProvider = typeUtilProvider;
    }

    /*
     * Loose catch block
     */
    public void reconcile(IDocument doc, SpringPropertiesReconcileEngine.IProblemCollector problemCollector, IProgressMonitor mon) {
        problemCollector.beginCollecting();
        try {
            try {
                YamlFileAST ast = this.parser.getAST(doc);
                FuzzyMap index = this.indexProvider.getIndex(doc);
                if (index != null && !index.isEmpty()) {
                    IndexNavigator nav = IndexNavigator.with((FuzzyMap<PropertyInfo>)index);
                    YamlASTReconciler reconciler = new YamlASTReconciler(problemCollector, this.typeUtilProvider.getTypeUtil(doc));
                    reconciler.reconcile(ast, nav, mon);
                }
            }
            catch (ParserException e) {
                String msg = e.getProblem();
                Mark mark = e.getProblemMark();
                problemCollector.accept(SpringPropertyProblem.error((String)msg, (int)mark.getIndex(), (int)1));
                problemCollector.endCollecting();
            }
            catch (ScannerException e) {
                String msg = e.getProblem();
                Mark mark = e.getProblemMark();
                problemCollector.accept(SpringPropertyProblem.error((String)msg, (int)mark.getIndex(), (int)1));
                problemCollector.endCollecting();
            }
            catch (Exception e) {
                SpringPropertiesEditorPlugin.log((Throwable)e);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                problemCollector.endCollecting();
            }
        }
        finally {
            problemCollector.endCollecting();
        }
    }
}

