/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.yaml.reconcile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.PropertyInfo;
import org.springframework.ide.eclipse.boot.util.StringUtil;

public class IndexNavigator {
    private static final char NAV_CHAR = '.';
    private String prefix = null;
    private FuzzyMap<PropertyInfo> index;

    private IndexNavigator(FuzzyMap<PropertyInfo> index) {
        this.index = index;
    }

    private IndexNavigator(FuzzyMap<PropertyInfo> index, String prefix) {
        this.index = index;
        this.prefix = prefix;
    }

    public static IndexNavigator with(FuzzyMap<PropertyInfo> index) {
        return new IndexNavigator(index);
    }

    public IndexNavigator selectSubProperty(String name) {
        return new IndexNavigator(this.index, this.join(this.prefix, name));
    }

    protected String join(String prefix, String postfix) {
        if (!StringUtil.hasText((String)prefix)) {
            return postfix;
        }
        return String.valueOf(prefix) + '.' + postfix;
    }

    public PropertyInfo getExactMatch() {
        PropertyInfo candidate;
        if (this.prefix != null && (candidate = (PropertyInfo)this.index.findLongestCommonPrefixEntry(this.prefix)).getId().equals(this.prefix)) {
            return candidate;
        }
        return null;
    }

    public PropertyInfo getExtensionCandidate() {
        String extendedPrefix = this.prefix == null ? "" : String.valueOf(this.prefix) + '.';
        PropertyInfo candidate = (PropertyInfo)this.index.findLongestCommonPrefixEntry(extendedPrefix);
        if (candidate.getId().startsWith(extendedPrefix)) {
            return candidate;
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public List<FuzzyMap.Match<PropertyInfo>> findMatching(String query) {
        if (!StringUtil.hasText((String)this.prefix)) {
            return this.index.find(query);
        }
        String dottedPrefix = String.valueOf(this.prefix) + ".";
        List candidates = this.index.find(String.valueOf(dottedPrefix) + query);
        if (!candidates.isEmpty()) {
            ArrayList<FuzzyMap.Match<PropertyInfo>> matches = new ArrayList<FuzzyMap.Match<PropertyInfo>>(candidates.size());
            for (FuzzyMap.Match match : candidates) {
                if (!((PropertyInfo)match.data).getId().startsWith(dottedPrefix)) continue;
                matches.add((FuzzyMap.Match<PropertyInfo>)match);
            }
            return matches;
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "IndexNavigator(" + this.prefix + ")";
    }

    public boolean isEmpty() {
        return this.getExactMatch() == null && this.getExtensionCandidate() == null;
    }
}

