/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eclipsecs.core.projectconfig;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.sf.eclipsecs.core.Messages;
import net.sf.eclipsecs.core.config.CheckConfiguration;
import net.sf.eclipsecs.core.config.CheckConfigurationFactory;
import net.sf.eclipsecs.core.config.ICheckConfiguration;
import net.sf.eclipsecs.core.config.ResolvableProperty;
import net.sf.eclipsecs.core.config.configtypes.ConfigurationTypes;
import net.sf.eclipsecs.core.config.configtypes.IConfigurationType;
import net.sf.eclipsecs.core.config.configtypes.ProjectConfigurationType;
import net.sf.eclipsecs.core.projectconfig.FileMatchPattern;
import net.sf.eclipsecs.core.projectconfig.FileSet;
import net.sf.eclipsecs.core.projectconfig.IProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.PluginFilters;
import net.sf.eclipsecs.core.projectconfig.ProjectConfiguration;
import net.sf.eclipsecs.core.projectconfig.filters.IFilter;
import net.sf.eclipsecs.core.util.CheckstylePluginException;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;

public final class ProjectConfigurationFactory {
    static final String PROJECT_CONFIGURATION_FILE = ".checkstyle";
    static final String CURRENT_FILE_FORMAT_VERSION = "1.2.0";
    private static final List<String> SUPPORTED_VERSIONS = Arrays.asList("1.0.0", "1.1.0", "1.2.0");

    private ProjectConfigurationFactory() {
    }

    public static IProjectConfiguration getConfiguration(IProject project) throws CheckstylePluginException {
        return ProjectConfigurationFactory.loadFromPersistence(project);
    }

    public static boolean isCheckConfigInUse(ICheckConfiguration checkConfig) throws CheckstylePluginException {
        return ProjectConfigurationFactory.getProjectsUsingConfig(checkConfig).size() > 0;
    }

    public static List<IProject> getProjectsUsingConfig(ICheckConfiguration checkConfig) throws CheckstylePluginException {
        ArrayList<IProject> result = new ArrayList<IProject>();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] projects = workspace.getRoot().getProjects();
        int i = 0;
        while (i < projects.length) {
            if (ProjectConfigurationFactory.getConfiguration(projects[i]).isConfigInUse(checkConfig)) {
                result.add(projects[i]);
            }
            ++i;
        }
        return result;
    }

    public static IProjectConfiguration createDefaultProjectConfiguration(IProject project) {
        FileSet standardFileSet = new FileSet(Messages.SimpleFileSetsEditor_nameAllFileset, CheckConfigurationFactory.getDefaultCheckConfiguration());
        try {
            standardFileSet.getFileMatchPatterns().add(new FileMatchPattern(".*"));
        }
        catch (CheckstylePluginException e) {
            throw new RuntimeException(e);
        }
        List<FileSet> fileSets = Arrays.asList(standardFileSet);
        IFilter[] filters = PluginFilters.getConfiguredFilters();
        ArrayList<IFilter> defaultFilters = new ArrayList<IFilter>();
        IFilter[] iFilterArray = filters;
        int n = filters.length;
        int n2 = 0;
        while (n2 < n) {
            IFilter filter = iFilterArray[n2];
            if (filter.isEnabled()) {
                defaultFilters.add(filter);
            }
            ++n2;
        }
        return new ProjectConfiguration(project, null, fileSets, defaultFilters, true, false);
    }

    private static IProjectConfiguration loadFromPersistence(IProject project) throws CheckstylePluginException {
        IProjectConfiguration configuration;
        block7: {
            configuration = null;
            IFile file = project.getFile(PROJECT_CONFIGURATION_FILE);
            boolean exists = file.exists();
            if (!exists) {
                return ProjectConfigurationFactory.createDefaultProjectConfiguration(project);
            }
            InputStream inStream = null;
            try {
                inStream = file.getContents(true);
                configuration = ProjectConfigurationFactory.getProjectConfiguration(inStream, project);
            }
            catch (DocumentException e) {
                CheckstylePluginException.rethrow(e);
                IOUtils.closeQuietly((InputStream)inStream);
                break block7;
            }
            catch (CoreException e) {
                try {
                    CheckstylePluginException.rethrow(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inStream);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inStream);
                break block7;
            }
            IOUtils.closeQuietly((InputStream)inStream);
        }
        return configuration;
    }

    private static IProjectConfiguration getProjectConfiguration(InputStream in, IProject project) throws DocumentException, CheckstylePluginException {
        SAXReader reader = new SAXReader();
        Document document = reader.read(in);
        Element root = document.getRootElement();
        String version = root.attributeValue("file-format-version");
        if (!SUPPORTED_VERSIONS.contains(version)) {
            throw new CheckstylePluginException(NLS.bind((String)Messages.errorUnknownFileFormat, (Object)version));
        }
        boolean useSimpleConfig = Boolean.valueOf(root.attributeValue("simple-config"));
        boolean syncFormatter = Boolean.valueOf(root.attributeValue("sync-formatter"));
        List<ICheckConfiguration> checkConfigs = ProjectConfigurationFactory.getLocalCheckConfigs(root, project);
        List<FileSet> fileSets = ProjectConfigurationFactory.getFileSets(root, checkConfigs);
        List<IFilter> filters = ProjectConfigurationFactory.getFilters(root);
        return new ProjectConfiguration(project, checkConfigs, fileSets, filters, useSimpleConfig, syncFormatter);
    }

    private static List<ICheckConfiguration> getLocalCheckConfigs(Element root, IProject project) {
        ArrayList<ICheckConfiguration> configurations = new ArrayList<ICheckConfiguration>();
        List configElements = root.elements("local-check-config");
        for (Element configEl : configElements) {
            IWorkspaceRoot workspaceRoot;
            String name = configEl.attributeValue("name");
            String description = configEl.attributeValue("description");
            String location = configEl.attributeValue("location");
            String type = configEl.attributeValue("type");
            IConfigurationType configType = ConfigurationTypes.getByInternalName(type);
            if (configType instanceof ProjectConfigurationType && (workspaceRoot = project.getWorkspace().getRoot()).findMember(location) == null) {
                location = project.getFullPath().append(location).toString();
            }
            ArrayList<ResolvableProperty> props = new ArrayList<ResolvableProperty>();
            List propertiesElements = configEl.elements("property");
            for (Element propsEl : propertiesElements) {
                ResolvableProperty prop = new ResolvableProperty(propsEl.attributeValue("name"), propsEl.attributeValue("value"));
                props.add(prop);
            }
            HashMap<String, String> additionalData = new HashMap<String, String>();
            List dataElements = configEl.elements("additional-data");
            for (Element dataEl : dataElements) {
                additionalData.put(dataEl.attributeValue("name"), dataEl.attributeValue("value"));
            }
            CheckConfiguration checkConfig = new CheckConfiguration(name, location, description, configType, false, props, additionalData);
            configurations.add(checkConfig);
        }
        return configurations;
    }

    private static List<FileSet> getFileSets(Element root, List<ICheckConfiguration> localCheckConfigs) throws CheckstylePluginException {
        ArrayList<FileSet> fileSets = new ArrayList<FileSet>();
        List fileSetElements = root.elements("fileset");
        for (Element fileSetEl : fileSetElements) {
            boolean local = Boolean.valueOf(fileSetEl.attributeValue("local"));
            FileSet fileSet = new FileSet();
            fileSet.setName(fileSetEl.attributeValue("name"));
            fileSet.setEnabled(Boolean.valueOf(fileSetEl.attributeValue("enabled")));
            ICheckConfiguration checkConfig = null;
            String checkConfigName = fileSetEl.attributeValue("check-config-name");
            if (local) {
                for (ICheckConfiguration tmp : localCheckConfigs) {
                    if (!tmp.getName().equals(checkConfigName)) continue;
                    checkConfig = tmp;
                    break;
                }
            } else {
                checkConfig = CheckConfigurationFactory.getByName(checkConfigName);
            }
            fileSet.setCheckConfig(checkConfig);
            ArrayList<FileMatchPattern> patterns = new ArrayList<FileMatchPattern>();
            List patternElements = fileSetEl.elements("file-match-pattern");
            for (Element patternEl : patternElements) {
                FileMatchPattern pattern = new FileMatchPattern(patternEl.attributeValue("match-pattern"));
                pattern.setIsIncludePattern(Boolean.valueOf(patternEl.attributeValue("include-pattern")));
                patterns.add(pattern);
            }
            fileSet.setFileMatchPatterns(patterns);
            fileSets.add(fileSet);
        }
        return fileSets;
    }

    private static List<IFilter> getFilters(Element root) {
        ArrayList<IFilter> filters = new ArrayList<IFilter>();
        List filterElements = root.elements("filter");
        for (Element filterEl : filterElements) {
            IFilter filter = PluginFilters.getByInternalName(filterEl.attributeValue("name"));
            if (filter == null) continue;
            filter.setEnabled(Boolean.valueOf(filterEl.attributeValue("enabled")));
            ArrayList<String> filterData = new ArrayList<String>();
            List dataElements = filterEl.elements("filter-data");
            for (Element dataEl : dataElements) {
                filterData.add(dataEl.attributeValue("value"));
            }
            filter.setFilterData(filterData);
            filters.add(filter);
        }
        return filters;
    }
}

